/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchard;

import de.p2tools.mtplayer.controller.livesearchard.M3U8Dto;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class M3U8Parser {
    public List<M3U8Dto> parse(String aM3U8Data) {
        ArrayList<M3U8Dto> result = new ArrayList<M3U8Dto>();
        List<String[]> pairs = M3U8Parser.getLinePairs(aM3U8Data);
        for (String[] pair : pairs) {
            M3U8Dto dto2 = new M3U8Dto(M3U8Parser.prepareUrl(pair[1]));
            M3U8Parser.parseMeta(pair[0], dto2);
            result.add(dto2);
        }
        pairs.clear();
        result.sort(Comparator.comparing(dto -> dto.getNormalizedMeta("RESOLUTION").orElse("")));
        return result;
    }

    private static void parseMeta(String aLine, M3U8Dto aDto) {
        int index = aLine.indexOf(58);
        if (index > 0) {
            String line = aLine.substring(index + 1);
            while ((index = line.indexOf(44)) > 0) {
                int indexQuote = line.indexOf(34);
                while (indexQuote + 1 < index && indexQuote != -1) {
                    indexQuote = line.indexOf(34, indexQuote + 1);
                    index = line.indexOf(44, indexQuote + 1);
                }
                if (index <= 0) break;
                M3U8Parser.parseMetaParameter(line.substring(0, index), aDto);
                line = line.substring(index + 1);
            }
            M3U8Parser.parseMetaParameter(line, aDto);
        }
    }

    private static void parseMetaParameter(String aParameter, M3U8Dto aDto) {
        String[] parameterParts = aParameter.split("=");
        aDto.addMeta(parameterParts[0], parameterParts[1]);
    }

    private static String prepareUrl(String aUrl) {
        String url = aUrl;
        int indexSuffix = aUrl.lastIndexOf(".m3u8");
        if (indexSuffix > 0) {
            url = aUrl.substring(0, indexSuffix + 5);
        }
        return url;
    }

    private static List<String[]> getLinePairs(String aM3U8Data) {
        String[] lines;
        ArrayList<String[]> pairs = new ArrayList<String[]>();
        String currentMeta = null;
        String currentUrl = null;
        for (String line : lines = StringUtils.split(aM3U8Data, '\n')) {
            if (line.startsWith("#EXT-X-STREAM-INF")) {
                currentMeta = line;
            } else if (line.startsWith("#")) {
                currentMeta = null;
                currentUrl = null;
            } else if (!line.isEmpty()) {
                currentUrl = line;
            }
            if (currentMeta == null || currentUrl == null) continue;
            pairs.add(new String[]{currentMeta, currentUrl});
            currentMeta = null;
            currentUrl = null;
        }
        return pairs;
    }
}

