/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearchard;

import com.fasterxml.jackson.databind.JsonNode;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveConst;
import de.p2tools.mtplayer.controller.livesearch.tools.MVHttpClient;
import de.p2tools.mtplayer.controller.livesearch.tools.UrlUtils;
import de.p2tools.mtplayer.controller.livesearchard.ArdMediaArrayToDownloadUrlsConverter;
import de.p2tools.mtplayer.controller.livesearchard.ArdVideoInfoDto;
import de.p2tools.mtplayer.controller.livesearchard.M3U8Dto;
import de.p2tools.mtplayer.controller.livesearchard.M3U8Parser;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ArdVideoInfoJsonDeserializer {
    private static final String ELEMENT_SUBTITLE_URL = "_subtitleUrl";
    private static final Request.Builder REQUEST_BUILDER = new Request.Builder();

    public ArdVideoInfoDto deserialize(JsonNode aJsonElement) {
        Map<LiveConst.Qualities, URL> resolutionUrlMap;
        ArdVideoInfoDto videoInfo = new ArdVideoInfoDto();
        JsonNode subtitleElement = aJsonElement.get(ELEMENT_SUBTITLE_URL);
        if (subtitleElement != null && !subtitleElement.isEmpty()) {
            videoInfo.setSubtitleUrl(subtitleElement.asText());
        }
        if ((resolutionUrlMap = new ArdMediaArrayToDownloadUrlsConverter().toDownloadUrls(aJsonElement)).size() == 1 && resolutionUrlMap.containsKey((Object)LiveConst.Qualities.NORMAL) && UrlUtils.getFileType(resolutionUrlMap.get((Object)LiveConst.Qualities.NORMAL).getFile()).get().equals("m3u8")) {
            this.loadM3U8(resolutionUrlMap);
        }
        resolutionUrlMap.forEach((key, value) -> videoInfo.put((LiveConst.Qualities)((Object)key), value.toString()));
        return videoInfo;
    }

    private void loadM3U8(Map<LiveConst.Qualities, URL> resolutionUrlMap) {
        URL m3u8File = resolutionUrlMap.get((Object)LiveConst.Qualities.NORMAL);
        Optional<String> m3u8Content = ArdVideoInfoJsonDeserializer.readContent(m3u8File);
        resolutionUrlMap.clear();
        if (m3u8Content.isPresent()) {
            String url = m3u8File.toString();
            String baseUrl = url.replaceAll(UrlUtils.getFileName(url).get(), "");
            M3U8Parser parser = new M3U8Parser();
            List<M3U8Dto> m3u8Data = parser.parse(m3u8Content.get());
            m3u8Data.forEach(entry -> {
                Optional<LiveConst.Qualities> resolution = entry.getResolution();
                if (resolution.isPresent()) {
                    try {
                        Object videoUrl = entry.getUrl();
                        if (!UrlUtils.getProtocol((String)videoUrl).isPresent()) {
                            videoUrl = baseUrl + (String)videoUrl;
                        }
                        resolutionUrlMap.put(resolution.get(), new URL((String)videoUrl));
                    }
                    catch (MalformedURLException e) {
                        P2Log.errorLog(959654789, (Exception)e, "ArdVideoInfoJsonDeserializer: invalid url " + entry.getUrl());
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readContent(URL aUrl) {
        Request request = REQUEST_BUILDER.url(aUrl).build();
        try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
             ResponseBody body = response.body();){
            if (response.isSuccessful() && body != null) {
                Optional<String> optional = Optional.of(body.string());
                return optional;
            }
            P2Log.errorLog(202014589, String.format("ArdVideoInfoJsonDeserializer: Request '%s' failed: %s", aUrl, response.code()));
            return Optional.empty();
        }
        catch (IOException ex) {
            P2Log.errorLog(501478963, (Exception)ex, "ArdVideoInfoJsonDeserializer: ");
        }
        return Optional.empty();
    }
}

