/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearch.tools;

import de.p2tools.mtplayer.controller.livesearch.tools.MVHttpClient;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String addDomainIfMissing(String aUrl, String aDomain) {
        if (aUrl != null && aUrl.startsWith("/")) {
            return aDomain + aUrl;
        }
        return aUrl;
    }

    public static String addProtocolIfMissing(String aUrl, String aProtocol) {
        if (aUrl == null || aUrl.isEmpty()) {
            return aUrl;
        }
        if (aUrl.startsWith("//")) {
            return aProtocol + aUrl;
        }
        if (!aUrl.contains("://") && !aUrl.startsWith("/")) {
            return aProtocol + "//" + aUrl;
        }
        return aUrl;
    }

    public static boolean existsUrl(@NotNull String aUrl) {
        boolean result = false;
        Request request = new Request.Builder().head().url(aUrl).build();
        try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                result = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Optional<String> getFileName(String aUrl) {
        String file;
        int index;
        if (aUrl != null && (index = aUrl.lastIndexOf(47)) > 0 && (file = aUrl.substring(index + 1)).contains(".")) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static Optional<String> getFileType(String aUrl) {
        int index;
        if (aUrl != null && (index = aUrl.lastIndexOf(46)) > 0) {
            int indexQuestionMark = aUrl.indexOf(63, index);
            if (indexQuestionMark < 0) {
                indexQuestionMark = aUrl.length();
            }
            return Optional.of(aUrl.substring(index + 1, indexQuestionMark));
        }
        return Optional.empty();
    }

    public static Optional<String> getProtocol(String aUrl) {
        int index;
        if (aUrl != null && (index = aUrl.indexOf("//")) > 0) {
            String protocol = aUrl.substring(0, index);
            return Optional.of(protocol);
        }
        return Optional.empty();
    }

    public static String removeParameters(String aUrl) {
        if (aUrl == null) {
            return null;
        }
        int indexParameterStart = aUrl.indexOf(63);
        if (indexParameterStart > 0) {
            return aUrl.substring(0, indexParameterStart);
        }
        return aUrl;
    }
}

