/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearch.tools;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.config.ProxyFactory;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.tools.JsoupConnection;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import org.jsoup.nodes.Document;

public class LiveFactory {
    private static final int TIMEOUT_LENGTH = 2000;
    public static int PROGRESS_NULL = -1;
    public static double PROGRESS_WAIT = -0.5;
    private static final DoubleProperty progressPropertyARD = new SimpleDoubleProperty(PROGRESS_NULL);
    private static final DoubleProperty progressPropertyZDF = new SimpleDoubleProperty(PROGRESS_NULL);

    private LiveFactory() {
    }

    public static void addToList(JsonInfoDto jsonInfoDto) {
        HashSet hashSet = new HashSet();
        Platform.runLater(() -> {
            if (jsonInfoDto.getList().isEmpty()) {
                P2Alert.showErrorAlert("Film suchen", "Es konnte kein Film gefunden werden.");
                return;
            }
            ProgData.getInstance().liveFilmFilterWorker.getLiveFilmList().forEach(filmDataMTP -> hashSet.add(LiveFactory.getHash(filmDataMTP)));
            jsonInfoDto.getList().forEach(filmDataMTP -> {
                if (!hashSet.contains(LiveFactory.getHash(filmDataMTP))) {
                    hashSet.add(LiveFactory.getHash(filmDataMTP));
                    ProgData.getInstance().liveFilmFilterWorker.getLiveFilmList().importFilmOnlyWithNr(filmDataMTP);
                }
            });
            AboFactory.setAboForList(false, ProgData.getInstance().liveFilmFilterWorker.getLiveFilmList());
        });
    }

    private static String getHash(FilmDataMTP filmDataMTP) {
        return filmDataMTP.getChannel() + filmDataMTP.getTitle() + filmDataMTP.getUrl();
    }

    public static void setFilmSize(FilmDataMTP film) {
        try {
            URL url = new URL(film.getUrl());
            long size = LiveFactory.getContentLength(url);
            film.arr[9] = "" + size / 1000L / 1000L;
        }
        catch (Exception ex) {
            P2Log.errorLog(959874501, ex, "setFilmSize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(URL url) {
        long ret = -1L;
        HttpURLConnection connection = null;
        try {
            connection = ProxyFactory.getUrlConnection(url);
            connection.setRequestProperty("User-Agent", ProgInfos.getUserAgent());
            connection.setReadTimeout(2000);
            connection.setConnectTimeout(2000);
            if (connection.getResponseCode() < 400) {
                ret = connection.getContentLengthLong();
            }
            if (ret < 300000L) {
                ret = -1L;
            }
        }
        catch (Exception ex) {
            ret = -1L;
            P2Log.errorLog(915254789, ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return ret;
    }

    public static void setProgress(CHANNEL channel, double count, int max) {
        double progress = count / (double)max;
        switch (channel) {
            case ARD: {
                Platform.runLater(() -> progressPropertyARD.setValue(progress));
                break;
            }
            case ZDF: {
                Platform.runLater(() -> progressPropertyZDF.setValue(progress));
            }
        }
        P2Log.debugLog("Filme suchen: " + progress);
    }

    public static void setProgressWait(CHANNEL channel) {
        switch (channel) {
            case ARD: {
                Platform.runLater(() -> progressPropertyARD.setValue(PROGRESS_WAIT));
                break;
            }
            case ZDF: {
                Platform.runLater(() -> progressPropertyZDF.setValue(PROGRESS_WAIT));
            }
        }
    }

    public static void setProgressNull(CHANNEL channel) {
        switch (channel) {
            case ARD: {
                Platform.runLater(() -> progressPropertyARD.setValue(PROGRESS_NULL));
                break;
            }
            case ZDF: {
                Platform.runLater(() -> progressPropertyZDF.setValue(PROGRESS_NULL));
            }
        }
    }

    public static DoubleProperty getProgressProperty(CHANNEL channel) {
        switch (channel) {
            case ARD: {
                return progressPropertyARD;
            }
            case ZDF: {
                return progressPropertyZDF;
            }
        }
        return progressPropertyZDF;
    }

    public static Optional<Document> loadPage(String url) {
        JsoupConnection jsoupConnection = new JsoupConnection();
        try {
            Document document = jsoupConnection.getDocumentTimeoutAfter(url, (int)TimeUnit.SECONDS.toMillis(60L));
            return Optional.of(document);
        }
        catch (IOException ex) {
            P2Log.errorLog(965654120, (Exception)ex, "loadPage: " + url);
            return Optional.empty();
        }
    }

    public static String getUrl(String url) throws IOException, InterruptedException {
        URI uri = URI.create(url);
        HttpRequest request = HttpRequest.newBuilder(uri).build();
        return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString()).body();
    }

    public static void addUrlSubtitle(FilmData film, String url) {
        film.arr[17] = url;
    }

    public static void addUrlKlein(FilmData film, String url) {
        film.arr[18] = url.isEmpty() ? "" : LiveFactory.getKlein(film.arr[14], url);
    }

    public static void addUrlHd(FilmData film, String url) {
        film.arr[19] = url.isEmpty() ? "" : LiveFactory.getKlein(film.arr[14], url);
    }

    private static String getKlein(String url1, String url2) {
        Object ret = "";
        boolean diff = false;
        for (int i = 0; i < url2.length(); ++i) {
            if (url1.length() > i) {
                if (url1.charAt(i) != url2.charAt(i)) {
                    if (!diff) {
                        ret = i + "|";
                    }
                    diff = true;
                }
            } else {
                diff = true;
            }
            if (!diff) continue;
            ret = (String)ret + url2.charAt(i);
        }
        return ret;
    }

    public static enum CHANNEL {
        ARD,
        ZDF;

    }
}

