/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearch.tools;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Optional;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static boolean checkTreePath(JsonNode aJsonElement, String ... aElementIds) {
        JsonNode elemToCheck = aJsonElement;
        for (String elementId : aElementIds) {
            if (elemToCheck == null || !elemToCheck.has(elementId)) {
                return false;
            }
            elemToCheck = elemToCheck.get(elementId);
        }
        return true;
    }

    public static Optional<String> getAttributeAsString(JsonNode aJsonObject, String aAttributeName) {
        JsonNode aElement;
        if (aJsonObject.has(aAttributeName) && (aElement = aJsonObject.get(aAttributeName)) != null) {
            return Optional.of(aElement.asText());
        }
        return Optional.empty();
    }

    public static Optional<Integer> getAttributeAsInt(JsonNode jsonNode, String attributeName) {
        JsonNode child;
        if (jsonNode.has(attributeName) && (child = jsonNode.get(attributeName)) != null) {
            return Optional.of(child.asInt());
        }
        return Optional.empty();
    }

    public static boolean hasElements(JsonNode aJsonObject, String ... aElementIds) {
        for (String elementId : aElementIds) {
            if (aJsonObject.has(elementId) && aJsonObject.get(elementId) != null) continue;
            return false;
        }
        return true;
    }

    public static Optional<Integer> getElementValueAsInteger(JsonNode aJsonElement, String ... aElementIds) {
        Optional<JsonNode> rs = JsonUtils.getElement(aJsonElement, aElementIds);
        return rs.map(JsonNode::asInt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasStringElements(JsonNode aJsonObject, String ... aElementIds) {
        if (!JsonUtils.hasElements(aJsonObject, aElementIds)) return false;
        if (!Arrays.stream(aElementIds).map(aJsonObject::get).map(JsonNode::asText).noneMatch(String::isEmpty)) return false;
        return true;
    }

    public static Optional<String> getElementValueAsString(JsonNode aJsonElement, String ... aElementIds) {
        Optional<JsonNode> rs = JsonUtils.getElement(aJsonElement, aElementIds);
        return rs.map(JsonNode::asText);
    }

    public static Optional<JsonNode> getElement(JsonNode aJsonElement, String ... aElementIds) {
        Optional<JsonNode> rs = Optional.empty();
        if (aElementIds == null || aElementIds.length == 0 || aJsonElement == null) {
            return rs;
        }
        JsonNode aJsonObject = aJsonElement;
        for (int i = 0; i < aElementIds.length - 1; ++i) {
            String elementId = aElementIds[i];
            if (!aJsonObject.has(elementId) || aJsonObject.get(elementId) == null) {
                aJsonObject = null;
                break;
            }
            aJsonObject = aJsonObject.get(elementId);
        }
        String elementId = aElementIds[aElementIds.length - 1];
        if (aJsonObject != null && aJsonObject.has(elementId) && aJsonObject.get(elementId) != null) {
            rs = Optional.of(aJsonObject.get(elementId));
        }
        return rs;
    }
}

