/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.livesearch;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.livesearch.JsonInfoDto;
import de.p2tools.mtplayer.controller.livesearch.ZdfBearerFactory;
import de.p2tools.mtplayer.controller.livesearch.ZdfSearchFactory;
import de.p2tools.mtplayer.controller.livesearch.tools.LiveFactory;
import de.p2tools.mtplayer.controller.livesearchzdf.ZdfFilmDetailDeserializer;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.List;
import java.util.Optional;
import org.jsoup.nodes.Document;

public class LiveSearchZdf {
    private static final String ATTRIBUTE_HREF = "href";
    private static final String URL_BASE = "https://www.zdf.de";
    private static final String URL_API_BASE = "https://api.zdf.de";

    public void loadLive(JsonInfoDto jsonInfoDto, boolean next) {
        LiveFactory.setProgressWait(LiveFactory.CHANNEL.ZDF);
        if (next) {
            jsonInfoDto.getList().clear();
        } else {
            jsonInfoDto.init();
            jsonInfoDto.setSearchString(ProgConfig.LIVE_FILM_GUI_SEARCH_ZDF.getValue());
            try {
                Optional<Document> document = LiveFactory.loadPage(URL_BASE);
                if (!document.isPresent()) {
                    P2Alert.showErrorAlert("Filme suchen", "Es konnten keine Filme gefunden werden.");
                    return;
                }
                Optional<String> searchBearer = ZdfBearerFactory.parseIndexPage(document.get());
                searchBearer.ifPresent(jsonInfoDto::setApi);
            }
            catch (Exception ex) {
                P2Log.errorLog(874587458, ex, "Url: https://www.zdf.de");
            }
        }
        List<String> list = ZdfSearchFactory.getFilmList(jsonInfoDto, next);
        for (String url : list) {
            url = this.addApiUrlBase("content/documents/" + url + ".json");
            new ZdfFilmDetailDeserializer(jsonInfoDto).deserialize(url);
        }
        LiveFactory.addToList(jsonInfoDto);
        LiveFactory.setProgressNull(LiveFactory.CHANNEL.ZDF);
        P2Log.sysLog("Filme gefunden: " + jsonInfoDto.getList().size());
    }

    public void loadUrl(JsonInfoDto jsonInfoDto) {
        LiveFactory.setProgressWait(LiveFactory.CHANNEL.ZDF);
        jsonInfoDto.init();
        jsonInfoDto.setStartUrl(ProgConfig.LIVE_FILM_GUI_SEARCH_URL_ZDF.getValue());
        try {
            Optional<Document> document = LiveFactory.loadPage(URL_BASE);
            if (document.isPresent()) {
                Optional<String> searchBearer = ZdfBearerFactory.parseIndexPage(document.get());
                searchBearer.ifPresent(jsonInfoDto::setApi);
                String url = jsonInfoDto.getStartUrl();
                P2Log.sysLog("Filme suchen: " + url);
                this.workFilm(jsonInfoDto, url);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(898945124, ex, "Url: https://www.zdf.de");
        }
        LiveFactory.addToList(jsonInfoDto);
        LiveFactory.setProgressNull(LiveFactory.CHANNEL.ZDF);
        P2Log.sysLog("Filme gefunden: " + jsonInfoDto.getList().size());
    }

    private void workFilm(JsonInfoDto jsonInfoDto, String url) {
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        url = url.substring(url.lastIndexOf("/") + 1);
        url = this.addApiUrlBase("content/documents/" + url + ".json");
        new ZdfFilmDetailDeserializer(jsonInfoDto).deserialize(url);
    }

    private String addApiUrlBase(String url) {
        if (!url.startsWith("/")) {
            return "https://api.zdf.de/" + url;
        }
        return URL_API_BASE + url;
    }
}

