/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filter.live;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filter.Filter;
import de.p2tools.mtplayer.controller.filter.live.LiveFilterProps;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.animation.PauseTransition;
import javafx.util.Duration;

public class LiveFilter
extends LiveFilterProps
implements Filter {
    private final PauseTransition pause = new PauseTransition(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));

    public LiveFilter() {
        this.initFilter();
    }

    @Override
    public void reportFilterReturn() {
        P2Log.debugLog("reportFilterReturn");
        this.pause.stop();
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_LIVE_FILTER_CHANGED);
    }

    public void clearFilter() {
        this.pause.setDuration(Duration.millis(0.0));
        this.setChannel("");
        this.setTheme("");
        this.setTitle("");
        this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
    }

    private void initFilter() {
        this.pause.setOnFinished(event -> this.reportFilterChange());
        this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        ProgConfig.SYSTEM_FILTER_WAIT_TIME.addListener((observable2, oldValue, newValue) -> {
            P2Log.debugLog("SYSTEM_FILTER_WAIT_TIME: " + ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue());
            this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        });
        this.clearFilter();
        this.channelProperty().addListener(l -> this.setFilterChange(true));
        this.themeProperty().addListener(l -> this.setFilterChange(false));
        this.titleProperty().addListener(l -> this.setFilterChange(false));
    }

    private void reportFilterChange() {
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_LIVE_FILTER_CHANGED);
    }

    private void setFilterChange(boolean startNow) {
        if (!startNow && ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue()) {
            this.pause.stop();
        } else {
            this.pause.playFromStart();
        }
    }
}

