/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filter.film;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.controller.filter.FilterWorker;
import de.p2tools.mtplayer.controller.filter.film.FilmFilterPredicateFactory;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;

public class FilmFilterRunner {
    private final ProgData progData;
    private final AtomicBoolean search = new AtomicBoolean(false);
    private final AtomicBoolean research = new AtomicBoolean(false);
    private int count = 0;
    private final boolean audio;

    public FilmFilterRunner(final ProgData progData, final boolean audio) {
        this.progData = progData;
        this.audio = audio;
        progData.aboList.listChangedProperty().addListener((observable2, oldValue, newValue) -> this.filterList());
        if (audio) {
            progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILTER_AUDIO_CHANGED){

                @Override
                public void ping() {
                    FilmFilterRunner.this.filterList();
                }
            });
        } else {
            progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILTER_FILM_CHANGED){

                @Override
                public void ping() {
                    FilmFilterRunner.this.filterList();
                }
            });
        }
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_HISTORY_CHANGED){

            @Override
            public void ping() {
                FilmFilter filmFilter;
                FilmFilter filmFilter2 = filmFilter = audio ? progData.filterWorkerAudio.getActFilterSettings() : progData.filterWorkerFilm.getActFilterSettings();
                if (filmFilter.isNotVis() && filmFilter.isNotHistory() || filmFilter.isOnlyVis() && filmFilter.getOnlyActHistory()) {
                    FilmFilterRunner.this.filterList();
                }
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_BLACKLIST_CHANGED){

            @Override
            public void ping() {
                FilmFilterRunner.this.filterList();
            }
        });
        progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_DIACRITIC_CHANGED){

            @Override
            public void ping() {
                FilmFilterRunner.this.filterList();
            }
        });
        ProgConfig.SYSTEM_FILTER_REG_EX_ONLY_CONTAIN.addListener((u, o, n) -> this.filterList());
    }

    private void filterList() {
        P2Duration.counterStart("filterList");
        if (!this.search.getAndSet(true)) {
            this.research.set(false);
            try {
                Platform.runLater(() -> {
                    String text = "=======================================\n   ===== FILTERN" + (this.audio ? " AUDIO: " : " FILM: ") + ++this.count + " =====\n=======================================";
                    P2Log.debugLog(text);
                    FilterWorker filterWorker = this.audio ? ProgData.getInstance().filterWorkerAudio : ProgData.getInstance().filterWorkerFilm;
                    if (filterWorker.getActFilterSettings().isThemeVis() && filterWorker.getActFilterSettings().isThemeIsExact() && !(this.audio ? ThemeListFactory.themeForChannelListAudio : ThemeListFactory.themeForChannelListFilm).contains(filterWorker.getActFilterSettings().getExactTheme())) {
                        P2Log.debugLog("Clear film-filter");
                        filterWorker.getActFilterSettings().switchFilterOff(true);
                        filterWorker.getActFilterSettings().setExactTheme("");
                        filterWorker.getActFilterSettings().switchFilterOff(false);
                    }
                    if (this.audio) {
                        this.progData.audioGuiController.getSel(true, false);
                        this.progData.audioListFiltered.filteredListSetPred(FilmFilterPredicateFactory.getPredicate(this.progData, true));
                        this.progData.audioGuiController.selectLastShown();
                    } else {
                        this.progData.filmGuiController.getSel(true, false);
                        this.progData.filmListFiltered.filteredListSetPred(FilmFilterPredicateFactory.getPredicate(this.progData, false));
                        this.progData.filmGuiController.selectLastShown();
                    }
                    this.search.set(false);
                    if (this.research.get()) {
                        this.filterList();
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.research.set(true);
        }
        P2Duration.counterStop("filterList");
    }
}

