/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.filter.FastFilter;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.controller.filter.FilmFilterList;
import de.p2tools.mtplayer.controller.filter.FilterBackward;
import de.p2tools.mtplayer.controller.worker.ThemeListFactory;
import java.util.Optional;

public class FilterWorker {
    public final FilmFilter actFilterSettings;
    public final FilmFilter storedFilterSettings;
    public final FilmFilter storedSmallFilterSettings;
    public final FilmFilterList filmFilterList;
    public final FilmFilterList backwardFilterList;
    public final FilmFilterList forwardFilterList;
    public final FastFilter fastFilter;
    private final FilterBackward filterBackward = new FilterBackward(false);
    private final boolean audio;

    public FilterWorker(boolean audio) {
        this.audio = audio;
        this.actFilterSettings = new FilmFilter("ActFilterSettings" + (audio ? "Audio" : "Film"), audio);
        this.storedFilterSettings = new FilmFilter("StoredFilterSettings" + (audio ? "Audio" : "Film"), audio);
        this.storedSmallFilterSettings = new FilmFilter("StoredSmallFilterSettings" + (audio ? "Audio" : "Film"), audio);
        if (audio) {
            this.filmFilterList = new FilmFilterList("FilmFilterListAudio");
            this.backwardFilterList = new FilmFilterList("FilmFilterListBackwardAudio");
            this.forwardFilterList = new FilmFilterList("FilmFilterListForwardAudio");
        } else {
            this.filmFilterList = new FilmFilterList("FilmFilterListFilm:SelectedFilterList");
            this.backwardFilterList = new FilmFilterList("FilmFilterListBackwardFilm");
            this.forwardFilterList = new FilmFilterList("FilmFilterListForwardFilm");
        }
        this.fastFilter = new FastFilter("FastFilter" + (audio ? "Audio" : "Film"), audio);
        this.getActFilterSettings().channelProperty().addListener(l -> ThemeListFactory.createThemeList(audio, ProgData.getInstance(), this.getActFilterSettings().channelProperty().getValueSafe()));
    }

    public FilmFilter getActFilterSettings() {
        return this.actFilterSettings;
    }

    public FilmFilter getStoredFilterSettings() {
        return this.storedFilterSettings;
    }

    public FilmFilter getStoredSmallFilterSettings() {
        return this.storedSmallFilterSettings;
    }

    public FilmFilterList getFilmFilterList() {
        return this.filmFilterList;
    }

    public FilmFilterList getBackwardFilterList() {
        return this.backwardFilterList;
    }

    public FilmFilterList getForwardFilterList() {
        return this.forwardFilterList;
    }

    public FastFilter getFastFilterSettings() {
        return this.fastFilter;
    }

    public FilterBackward getBackwardFilmFilter() {
        return this.filterBackward;
    }

    public synchronized void setActFilterSettings(FilmFilter sf) {
        if (sf == null) {
            return;
        }
        this.actFilterSettings.switchFilterOff(true);
        int black = this.actFilterSettings.blacklistOnOffProperty().getValue();
        sf.copyTo(this.actFilterSettings);
        this.actFilterSettings.switchFilterOff(false);
        if (this.actFilterSettings.blacklistOnOffProperty().getValue() == black) {
            this.postFilterChange();
        } else {
            this.postBlacklistChange();
        }
    }

    public synchronized void setFilterFromAbo(Optional<AboData> oAbo) {
        if (oAbo.isEmpty()) {
            return;
        }
        AboData abo = oAbo.get();
        this.actFilterSettings.switchFilterOff(true);
        this.actFilterSettings.turnOffFilter();
        this.actFilterSettings.setChannelAndVis(abo.getChannel());
        this.actFilterSettings.setThemeAndVis(abo.getTheme(), abo.isThemeExact());
        this.actFilterSettings.setThemeTitleAndVis(abo.getThemeTitle());
        this.actFilterSettings.setTitleAndVis(abo.getTitle());
        this.actFilterSettings.setSomewhereVis(true);
        this.actFilterSettings.setSomewhere(abo.getSomewhere());
        this.actFilterSettings.setMinMaxDurVis(true);
        this.actFilterSettings.setMinDur(abo.getMinDurationMinute());
        this.actFilterSettings.setMaxDur(abo.getMaxDurationMinute());
        this.actFilterSettings.setTimeRangeVis(true);
        this.actFilterSettings.setTimeRange(abo.getTimeRange());
        this.forwardFilterList.clear();
        this.actFilterSettings.switchFilterOff(false);
        this.postFilterChange();
    }

    public synchronized void clearFilter() {
        this.actFilterSettings.switchFilterOff(true);
        if (this.actFilterSettings.isTextFilterEmpty()) {
            this.actFilterSettings.clearFilter();
        } else {
            this.actFilterSettings.clearTxtFilter();
        }
        this.forwardFilterList.clear();
        this.actFilterSettings.switchFilterOff(false);
        this.postFilterChange();
    }

    private void postFilterChange() {
        this.filterBackward.addBackward();
        if (this.audio) {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
        } else {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
        }
    }

    private void postBlacklistChange() {
        System.out.println("=====> FilterWorker");
        BlacklistFilterFactory.makeBlackFilteredFilmlist(this.audio);
        if (this.audio) {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
        } else {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
        }
    }

    public static void setSmallFilter(FilmFilter filmFilter) {
        filmFilter.setChannelVis(true);
        filmFilter.setThemeTitleVis(true);
        filmFilter.setThemeVis(true);
        filmFilter.setThemeIsExact(true);
        filmFilter.setTimeRangeVis(true);
        filmFilter.setMinMaxDurVis(true);
        filmFilter.setTitleVis(false);
        filmFilter.setSomewhereVis(false);
        filmFilter.setUrlVis(false);
        filmFilter.setMinMaxTimeVis(false);
        filmFilter.setMinMaxTimeInvert(false);
        filmFilter.setShowDateVis(false);
        filmFilter.setNotVis(false);
        filmFilter.setOnlyVis(false);
    }
}

