/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.filter.FilmFilterProps;
import de.p2tools.mtplayer.controller.filter.Filter;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.animation.PauseTransition;
import javafx.util.Duration;

public class FilmFilter
extends FilmFilterProps
implements Filter {
    private boolean filterIsOff = true;
    private final PauseTransition pause = new PauseTransition(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
    private boolean audio = false;

    public FilmFilter() {
        this.initFilter();
        this.setName("Filter");
    }

    public FilmFilter(String name) {
        this.initFilter();
        this.setName(name);
    }

    public FilmFilter(String tag, boolean audio) {
        this.TAG = tag;
        this.audio = audio;
        this.initFilter();
    }

    @Override
    public void reportFilterReturn() {
        P2Log.debugLog("reportFilterReturn");
        this.pause.stop();
        if (this.audio) {
            ProgData.getInstance().filterWorkerAudio.getBackwardFilmFilter().addBackward();
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
        } else {
            ProgData.getInstance().filterWorkerFilm.getBackwardFilmFilter().addBackward();
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
        }
    }

    private void reportFilterChange() {
        if (!this.filterIsOff) {
            if (this.audio) {
                ProgData.getInstance().filterWorkerAudio.getBackwardFilmFilter().addBackward();
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
                System.out.println("=================================");
                System.out.println("AUDIO FILTER MELDEN");
            } else {
                ProgData.getInstance().filterWorkerFilm.getBackwardFilmFilter().addBackward();
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
                System.out.println("=================================");
                System.out.println("FILM FILTER MELDEN");
            }
        }
    }

    public void switchFilterOff(boolean switchOff) {
        this.pause.stop();
        this.filterIsOff = switchOff;
    }

    public void turnOffFilter() {
        this.clearFilter();
        this.setChannelVis(false);
        this.setThemeVis(false);
        this.setThemeTitleVis(false);
        this.setTitleVis(false);
        this.setSomewhereVis(false);
        this.setUrlVis(false);
        this.setTimeRangeVis(false);
        this.setMinMaxDurVis(false);
        this.setMinMaxTimeVis(false);
        this.setShowDateVis(false);
        this.setOnlyVis(false);
        this.setNotVis(false);
    }

    public void clearTxtFilter() {
        this.pause.setDuration(Duration.millis(0.0));
        this.setChannel("");
        this.setTheme("");
        this.setExactTheme("");
        this.setThemeTitle("");
        this.setTitle("");
        this.setSomewhere("");
        this.setUrl("");
        this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
    }

    public void clearFilter() {
        this.setChannel("");
        this.setTheme("");
        this.setExactTheme("");
        this.setThemeTitle("");
        this.setTitle("");
        this.setSomewhere("");
        this.setUrl("");
        this.setTimeRange(0);
        this.setMinDur(0);
        this.setMaxDur(150);
        this.setMinTime(0);
        this.setMaxTime(86400);
        this.setShowDate("");
        this.setOnlyBookmark(false);
        this.setOnlyHd(false);
        this.setOnlyNew(false);
        this.setOnlyUt(false);
        this.setOnlyMark(false);
        this.setOnlyLive(false);
        this.setOnlyActHistory(false);
        this.setNotAbo(false);
        this.setNotHistory(false);
        this.setNotDouble(false);
        this.setNotGeo(false);
        this.setNotFuture(false);
    }

    public boolean isTextFilterEmpty() {
        return this.getChannel().isEmpty() && this.getResTheme().isEmpty() && this.getThemeTitle().isEmpty() && this.getTitle().isEmpty() && this.getSomewhere().isEmpty() && this.getUrl().isEmpty();
    }

    public void setChannelAndVis(String set) {
        this.setChannel(set);
        this.setChannelVis(true);
    }

    public void setThemeAndVis(String set, boolean exact) {
        if (exact) {
            this.setExactTheme(set);
        } else {
            this.setTheme(set);
        }
        this.setThemeIsExact(exact);
        this.setThemeVis(true);
    }

    public void setThemeTitleAndVis(String set) {
        this.setThemeTitle(set);
        this.setThemeTitleVis(true);
    }

    public void setTitleAndVis(String set) {
        this.setTitle(set);
        this.setTitleVis(true);
    }

    private void initFilter() {
        this.pause.setOnFinished(event -> this.reportFilterChange());
        this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        ProgConfig.SYSTEM_FILTER_WAIT_TIME.addListener((observable2, oldValue, newValue) -> {
            P2Log.debugLog("SYSTEM_FILTER_WAIT_TIME: " + ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue());
            this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        });
        this.clearFilter();
        this.setChannelVis(true);
        this.setThemeTitleVis(true);
        this.setThemeVis(false);
        this.setThemeIsExact(false);
        this.setTitleVis(false);
        this.setSomewhereVis(false);
        this.setUrlVis(false);
        this.setTimeRangeVis(true);
        this.setMinMaxDurVis(true);
        this.setMinMaxTimeVis(false);
        this.setMinMaxTimeInvert(false);
        this.setShowDateVis(false);
        this.setNotVis(false);
        this.setOnlyVis(false);
        this.nameProperty().addListener(l -> this.setFilterChange(true));
        this.channelVisProperty().addListener(l -> this.setFilterChange(true));
        this.channelProperty().addListener(l -> this.setFilterChange(true));
        this.themeVisProperty().addListener(l -> this.setFilterChange(true));
        this.themeIsExactProperty().addListener(l -> this.setFilterChange(true));
        this.exactThemeProperty().addListener(l -> this.setFilterChange(true));
        this.themeProperty().addListener(l -> this.setFilterChange(false));
        this.themeTitleVisProperty().addListener(l -> this.setFilterChange(true));
        this.themeTitleProperty().addListener(l -> this.setFilterChange(false));
        this.titleVisProperty().addListener(l -> this.setFilterChange(true));
        this.titleProperty().addListener(l -> this.setFilterChange(false));
        this.somewhereVisProperty().addListener(l -> this.setFilterChange(true));
        this.somewhereProperty().addListener(l -> this.setFilterChange(false));
        this.urlVisProperty().addListener(l -> this.setFilterChange(true));
        this.urlProperty().addListener(l -> this.setFilterChange(false));
        this.timeRangeVisProperty().addListener(l -> this.setFilterChange(true));
        this.timeRangeProperty().addListener(l -> this.setFilterChange(true));
        this.minMaxDurVisProperty().addListener((observable2, oldValue, newValue) -> this.setFilterChange(true));
        this.minDurProperty().addListener(l -> this.setFilterChange(true));
        this.maxDurProperty().addListener(l -> this.setFilterChange(true));
        this.minMaxTimeVisProperty().addListener((observable2, oldValue, newValue) -> this.setFilterChange(true));
        this.minMaxTimeInvertProperty().addListener((observable2, oldValue, newValue) -> this.setFilterChange(true));
        this.minTimeProperty().addListener(l -> this.setFilterChange(true));
        this.maxTimeProperty().addListener(l -> this.setFilterChange(true));
        this.showDateVisProperty().addListener(l -> this.setFilterChange(true));
        this.showDateProperty().addListener(l -> this.setFilterChange(true));
        this.onlyVisProperty().addListener(l -> this.setFilterChange(true));
        this.onlyBookmarkProperty().addListener(l -> this.setFilterChange(true));
        this.onlyHdProperty().addListener(l -> this.setFilterChange(true));
        this.onlyNewProperty().addListener(l -> this.setFilterChange(true));
        this.onlyUtProperty().addListener(l -> this.setFilterChange(true));
        this.onlyMarkProperty().addListener(l -> this.setFilterChange(true));
        this.onlyLiveProperty().addListener(l -> this.setFilterChange(true));
        this.onlyActHistoryProperty().addListener(l -> this.setFilterChange(true));
        this.notVisProperty().addListener(l -> this.setFilterChange(true));
        this.notAboProperty().addListener(l -> this.setFilterChange(true));
        this.notHistoryProperty().addListener(l -> this.setFilterChange(true));
        this.notDoubleProperty().addListener(l -> this.setFilterChange(true));
        this.notGeoProperty().addListener(l -> this.setFilterChange(true));
        this.notFutureProperty().addListener(l -> this.setFilterChange(true));
        this.blacklistOnOffProperty().addListener(l -> this.reportBlacklistChange());
    }

    private void reportBlacklistChange() {
        System.out.println("====> FilmFilter");
        if (!this.filterIsOff) {
            BlacklistFilterFactory.makeBlackFilteredFilmlist(this.audio);
            if (this.audio) {
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
            } else {
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
            }
        }
    }

    private void setFilterChange(boolean startNow) {
        if (!startNow && ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue()) {
            this.pause.stop();
        } else {
            this.pause.playFromStart();
        }
    }
}

