/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.filter;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.filter.FastFilterProps;
import de.p2tools.mtplayer.controller.filter.Filter;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.animation.PauseTransition;
import javafx.util.Duration;

public final class FastFilter
extends FastFilterProps
implements Filter {
    private final PauseTransition pause = new PauseTransition(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
    private final boolean audio;

    public FastFilter(String tag, boolean audio) {
        this.TAG = tag;
        this.audio = audio;
        this.initFilter();
    }

    public void clearFilter() {
        this.setFilterTerm("");
        if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue()) {
            this.reportFilterReturn();
        }
    }

    @Override
    public void reportFilterReturn() {
        P2Log.debugLog("reportFilterReturn");
        this.pause.stop();
        if (this.audio) {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
        } else {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
        }
    }

    private void initFilter() {
        this.pause.setOnFinished(event -> {
            if (this.audio) {
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_AUDIO_CHANGED);
            } else {
                ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_FILTER_FILM_CHANGED);
            }
        });
        this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        ProgConfig.SYSTEM_FILTER_WAIT_TIME.addListener((observable2, oldValue, newValue) -> {
            P2Log.debugLog("SYSTEM_FILTER_WAIT_TIME: " + ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue());
            this.pause.setDuration(Duration.millis(ProgConfig.SYSTEM_FILTER_WAIT_TIME.getValue().intValue()));
        });
        this.clearFilter();
        this.filterTermProperty().addListener(l -> this.setTxtFilterChange());
    }

    private void setTxtFilterChange() {
        if (ProgConfig.SYSTEM_FILTER_RETURN.getValue().booleanValue()) {
            this.pause.stop();
        } else {
            this.pause.playFromStart();
        }
    }
}

