/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.utdata;

import de.p2tools.mtplayer.controller.data.utdata.UtData;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class UtDataList
extends SimpleListProperty<UtData>
implements P2DataList<UtData> {
    public final String TAG;
    private final ObservableList<UtData> undoList = FXCollections.observableArrayList();

    public UtDataList(boolean ut) {
        super(FXCollections.observableArrayList());
        this.TAG = ut ? "UtDataList" : "MarkDataList";
    }

    @Override
    public String getTag() {
        return this.TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Filme mit UT im Film";
    }

    @Override
    public UtData getNewItem() {
        return new UtData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(UtData.class)) {
            this.add((UtData)obj);
        }
    }

    public void init(boolean ut) {
        this.addDataToUndoList(this);
        this.clear();
        if (ut) {
            this.add(new UtData("ARTE", "(mit Untertitel)"));
            this.add(new UtData("ARTE", "(Originalversion mit Untertitel)"));
            this.add(new UtData("ZDF", "- OmU"));
            this.add(new UtData("", "(OmU)"));
        } else {
            this.add(new UtData("", "Geb\u00e4rdensprache"));
        }
    }

    public int up(int idx, boolean up) {
        UtData replace = (UtData)this.remove(idx);
        int neu = idx;
        if (up) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, replace);
        return neu;
    }

    public ObservableList<UtData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addDataToUndoList(List<UtData> list) {
        this.undoList.clear();
        this.undoList.addAll((Collection<UtData>)list);
    }

    public synchronized void undoData() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.addAll(this.undoList);
        this.undoList.clear();
    }
}

