/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.setdata;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.setdata.ProgramData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.data.setdata.SetDataList;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.dialogs.P2DialogFileChooser;
import de.p2tools.p2lib.tools.P2InfoFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import javafx.stage.Stage;

public class SetReplacePatternFactory {
    public static final String PATTERN_PATH_DEST = "ZIELPFAD";
    public static final String PATTERN_PATH_VLC = "PFAD_VLC";
    public static final String PATTERN_PATH_FFMPEG = "PFAD_FFMPEG";

    public static boolean progReplacePattern(Stage stage, SetDataList list) {
        boolean ret = true;
        for (SetData pSet : list) {
            if (SetReplacePatternFactory.progReplacePattern(stage, pSet)) continue;
            ret = false;
        }
        return ret;
    }

    private static boolean progReplacePattern(Stage stage, SetData pSet) {
        ProgramData prog;
        int p;
        pSet.setDestPath(pSet.getDestPath().replace(PATTERN_PATH_DEST, ((String)ProgConfig.DOWNLOAD_PATH.get()).isEmpty() ? P2InfoFactory.getStandardDownloadPath() : (CharSequence)ProgConfig.DOWNLOAD_PATH.get()));
        String vlc = "";
        String ffmpeg = "";
        for (p = 0; p < pSet.getProgramList().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.getProgPath().contains(PATTERN_PATH_VLC) && !prog.getProgSwitch().contains(PATTERN_PATH_VLC)) continue;
            vlc = SetReplacePatternFactory.getPathVlc(stage);
            break;
        }
        for (p = 0; p < pSet.getProgramList().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.getProgPath().contains(PATTERN_PATH_FFMPEG) && !prog.getProgSwitch().contains(PATTERN_PATH_FFMPEG)) continue;
            ffmpeg = SetReplacePatternFactory.getPathFFmpeg(stage);
            break;
        }
        for (p = 0; p < pSet.getProgramList().size(); ++p) {
            prog = pSet.getProg(p);
            prog.setProgPath(prog.getProgPath().replaceAll(PATTERN_PATH_VLC, Matcher.quoteReplacement(vlc)));
            prog.setProgSwitch(prog.getProgSwitch().replaceAll(PATTERN_PATH_VLC, Matcher.quoteReplacement(vlc)));
            prog.setProgPath(prog.getProgPath().replaceAll(PATTERN_PATH_FFMPEG, Matcher.quoteReplacement(ffmpeg)));
            prog.setProgSwitch(prog.getProgSwitch().replaceAll(PATTERN_PATH_FFMPEG, Matcher.quoteReplacement(ffmpeg)));
        }
        return true;
    }

    private static String getPathVlc(Stage stage) {
        String orgPath = SetFactory.getTemplatePathVlc();
        if (((String)ProgConfig.SYSTEM_PATH_VLC.get()).isEmpty()) {
            ProgConfig.SYSTEM_PATH_VLC.set(orgPath);
        }
        Path path = Paths.get((String)ProgConfig.SYSTEM_PATH_VLC.get(), new String[0]);
        if (!((String)ProgConfig.SYSTEM_PATH_VLC.get()).isEmpty() && Files.exists(path, new LinkOption[0])) {
            return (String)ProgConfig.SYSTEM_PATH_VLC.get();
        }
        path = Paths.get(orgPath, new String[0]);
        if (!orgPath.isEmpty() && Files.exists(path, new LinkOption[0])) {
            ProgConfig.SYSTEM_PATH_VLC.set(orgPath);
            return (String)ProgConfig.SYSTEM_PATH_VLC.get();
        }
        ProgConfig.SYSTEM_PATH_VLC.setValue(P2DialogFileChooser.showFileChooser(stage, "VLC", "VLC wird nicht gefunden.", "Bitte den Pfad zum" + P2LibConst.LINE_SEPARATOR + "VLC-Player angeben.", false));
        return (String)ProgConfig.SYSTEM_PATH_VLC.get();
    }

    private static String getPathFFmpeg(Stage stage) {
        String orgPath = SetFactory.getTemplatePathFFmpeg();
        if (((String)ProgConfig.SYSTEM_PATH_FFMPEG.get()).isEmpty()) {
            ProgConfig.SYSTEM_PATH_FFMPEG.set(orgPath);
        }
        Path path = Paths.get((String)ProgConfig.SYSTEM_PATH_FFMPEG.get(), new String[0]);
        if (!((String)ProgConfig.SYSTEM_PATH_FFMPEG.get()).isEmpty() && Files.exists(path, new LinkOption[0])) {
            return (String)ProgConfig.SYSTEM_PATH_FFMPEG.get();
        }
        path = Paths.get(orgPath, new String[0]);
        if (!orgPath.isEmpty() && Files.exists(path, new LinkOption[0])) {
            ProgConfig.SYSTEM_PATH_FFMPEG.set(orgPath);
            return (String)ProgConfig.SYSTEM_PATH_FFMPEG.get();
        }
        ProgConfig.SYSTEM_PATH_FFMPEG.setValue(P2DialogFileChooser.showFileChooser(stage, "ffmpeg", "ffmpeg wird nicht gefunden.", "Bitte den Pfad zu" + P2LibConst.LINE_SEPARATOR + "ffmpeg angeben.", false));
        return (String)ProgConfig.SYSTEM_PATH_FFMPEG.get();
    }
}

