/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.setdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.setdata.SetDataList;
import de.p2tools.mtplayer.controller.data.setdata.SetReplacePatternFactory;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigReadFile;
import de.p2tools.p2lib.tools.P2Index;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import javafx.stage.Stage;

public class SetImportFactory
extends LinkedList<String[]> {
    public static boolean getStandardSet(Stage stage) {
        SetDataList setDataList = new SetDataList();
        try {
            switch (P2InfoFactory.getOs()) {
                case LINUX: {
                    SetImportFactory.loadSetDataUrl(setDataList, "https://www.p2tools.de/extra/mtplayer/v-8/pset_linux.xml");
                    break;
                }
                case MAC: {
                    SetImportFactory.loadSetDataUrl(setDataList, "https://www.p2tools.de/extra/mtplayer/v-8/pset_mac.xml");
                    break;
                }
                default: {
                    SetImportFactory.loadSetDataUrl(setDataList, "https://www.p2tools.de/extra/mtplayer/v-8/pset_windows.xml");
                }
            }
            if (setDataList.isEmpty()) {
                P2Log.sysLog("Sets laden hat nicht geklappt, dann aus dem jar");
                switch (P2InfoFactory.getOs()) {
                    case LINUX: {
                        SetImportFactory.loadSetDataLocalFile(setDataList, "de/p2tools/mtplayer/res/file/pset_linux.xml");
                        break;
                    }
                    case MAC: {
                        SetImportFactory.loadSetDataLocalFile(setDataList, "de/p2tools/mtplayer/res/file/pset_mac.xml");
                        break;
                    }
                    default: {
                        SetImportFactory.loadSetDataLocalFile(setDataList, "de/p2tools/mtplayer/res/file/pset_windows.xml");
                    }
                }
            }
            if (!setDataList.isEmpty()) {
                SetReplacePatternFactory.progReplacePattern(stage, setDataList);
                setDataList.forEach(s -> s.setId(P2Index.getIndexStr()));
            } else {
                P2Log.sysLog("Sets laden hat nicht geklappt");
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(202014578, ex);
        }
        ProgData.getInstance().setDataList.addSetData(setDataList);
        return !setDataList.isEmpty();
    }

    private static void loadSetDataUrl(SetDataList setDataList, String url) {
        P2Log.sysLog("Sets laden von: " + url);
        ConfigFile configFile = new ConfigFile(url, false);
        configFile.addConfigs(setDataList);
        ConfigReadFile.readConfig(configFile);
    }

    private static void loadSetDataLocalFile(SetDataList setDataList, String file) throws IOException {
        P2Log.sysLog("Sets laden von: " + file);
        InputStreamReader is = new InputStreamReader(ClassLoader.getSystemResource(file).openStream(), StandardCharsets.UTF_8);
        ConfigFile configFile = new ConfigFile(is, false);
        configFile.addConfigs(setDataList);
        ConfigReadFile.readConfig(configFile);
    }
}

