/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.setdata;

import de.p2tools.mtplayer.controller.data.setdata.ProgramData;
import de.p2tools.mtplayer.controller.data.setdata.ProgramList;
import de.p2tools.mtplayer.controller.data.setdata.SetDataProps;
import de.p2tools.mtplayer.controller.data.setdata.SetFactory;
import de.p2tools.p2lib.tools.P2Index;

public class SetData
extends SetDataProps {
    public SetData() {
        this.setId(P2Index.getIndexStr());
    }

    public SetData(String name) {
        this.setId(P2Index.getIndexStr());
        this.setVisibleName(name);
        this.setButton(true);
    }

    public boolean addProg(ProgramData prog) {
        return this.programList.add(prog);
    }

    public ProgramList getProgramList() {
        return this.programList;
    }

    public ProgramData getProg(int i) {
        return (ProgramData)this.programList.get(i);
    }

    public boolean progsContainPath() {
        boolean ret = false;
        for (ProgramData progData : this.programList) {
            if (!progData.getProgSwitch().contains("**") && !progData.getProgSwitch().contains("%a") && !progData.getProgSwitch().contains("%b")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public ProgramData getProgUrl(String url) {
        ProgramData ret = null;
        if (!this.programList.isEmpty()) {
            if (this.programList.size() == 1) {
                ret = (ProgramData)this.programList.get(0);
            } else {
                for (ProgramData progData : this.programList) {
                    if (!progData.urlTesten(url)) continue;
                    ret = progData;
                    break;
                }
                if (!this.programList.isEmpty() && ret == null) {
                    ret = (ProgramData)this.programList.get(this.programList.size() - 1);
                }
            }
        }
        return ret;
    }

    public String getDestFileName(String url) {
        ProgramData programData = this.getProgUrl(url);
        String ret = this.getDestName();
        if (!this.checkDownloadDirect(url) && programData != null && !programData.getDestName().isEmpty()) {
            ret = programData.getDestName();
        }
        return ret;
    }

    public boolean checkDownloadDirect(String url) {
        return (!this.getPrefix().isEmpty() || !this.getSuffix().isEmpty()) && SetFactory.testPrefix(this.getPrefix(), url, true) && SetFactory.testPrefix(this.getSuffix(), url, false);
    }

    public SetData getCopy() {
        SetData ret = new SetData();
        for (int i = 0; i < this.properties.length; ++i) {
            ret.properties[i].setValue(this.properties[i].getValue());
        }
        ret.setId(P2Index.getIndexStr());
        ret.setVisibleName("Kopie-" + this.getVisibleName());
        ret.setPlay(false);
        for (ProgramData programData : this.getProgramList()) {
            ret.addProg(programData.getCopy());
        }
        return ret;
    }
}

