/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.replace;

import de.p2tools.mtplayer.controller.config.ProgConst;
import de.p2tools.mtplayer.controller.data.replace.ReplaceData;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class ReplaceList
extends SimpleListProperty<ReplaceData>
implements P2DataList<ReplaceData> {
    public static final String TAG = "ReplaceList";
    private final ObservableList<ReplaceData> undoList = FXCollections.observableArrayList();

    public ReplaceList() {
        super(FXCollections.observableArrayList());
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller ReplaceData";
    }

    @Override
    public ReplaceData getNewItem() {
        return new ReplaceData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(ReplaceData.class)) {
            this.add((ReplaceData)obj);
        }
    }

    public void init() {
        this.addDataToUndoList(this);
        this.clear();
        this.add(new ReplaceData(" ", "_"));
        this.add(new ReplaceData("?", "_"));
    }

    public String replace(String strCheck, boolean path) {
        this.removeIf(replaceData -> replaceData.getFrom().isEmpty());
        String newString = strCheck;
        for (ReplaceData replaceData2 : this) {
            if (!replaceData2.isActive() || path && replaceData2.getFrom().equals(File.separator)) continue;
            String tmp = newString;
            String replace = replaceData2.getFrom();
            if (replace.startsWith(ProgConst.REG_EX)) {
                try {
                    replace = replace.substring(ProgConst.REG_EX.length());
                    newString = newString.replaceAll(replace, replaceData2.getTo());
                }
                catch (PatternSyntaxException ex) {
                    P2Log.errorLog(201360457, "RegEx fehlerhaft: " + replace);
                }
            } else {
                newString = newString.replace(replace, replaceData2.getTo());
            }
            if (!replaceData2.isStop() || tmp.equals(newString)) continue;
            break;
        }
        return newString;
    }

    public int top(int idx, boolean up) {
        int ret;
        ReplaceData replace = (ReplaceData)this.remove(idx);
        if (up) {
            this.add(0, replace);
            ret = 0;
        } else {
            this.add(replace);
            ret = this.getSize() - 1;
        }
        return ret;
    }

    public int up(int idx, boolean up) {
        ReplaceData replace = (ReplaceData)this.remove(idx);
        int neu = idx;
        if (up) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, replace);
        return neu;
    }

    public ObservableList<ReplaceData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addDataToUndoList(List<ReplaceData> list) {
        this.undoList.clear();
        this.undoList.addAll((Collection<ReplaceData>)list);
    }

    public synchronized void undoData() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.addAll(this.undoList);
        this.undoList.clear();
    }
}

