/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.propose;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningProposeFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.propose.ProposeData;
import java.util.Hashtable;

public class ProposeFactory {
    private ProposeFactory() {
    }

    public static void generateProposeList() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        ProgData.getInstance().proposeList.clear();
        ProgData.getInstance().historyList.forEach(historyData -> CleaningProposeFactory.cleanSearchText(historyData, hashtable));
        hashtable.forEach((s, i) -> {
            if (i > 250) {
                ProposeData proposeData = new ProposeData((String)s, (int)i);
                ProgData.getInstance().proposeList.add(proposeData);
            }
        });
        hashtable.clear();
    }

    public static void generateFilmList(int minDur, int maxDur) {
        ProgData.getInstance().proposeList.getFilmDataList().clear();
        ProgData.getInstance().filmList.forEach(filmDataMTP -> ProgData.getInstance().proposeList.forEach(p -> {
            if (filmDataMTP.getTheme().contains(p.getName()) || filmDataMTP.getTitle().contains(p.getName())) {
                int prop = p.getCount() / (filmDataMTP.getTheme().length() + filmDataMTP.getTitle().length());
                filmDataMTP.addPropose(prop);
            }
        }));
        ProgData.getInstance().filmList.filtered(p -> !p.isShown()).filtered(p -> p.getPropose() > 20).filtered(p -> minDur == 0 || p.getDurationMinute() >= minDur).filtered(p -> maxDur == 150 || p.getDurationMinute() <= maxDur).forEach(f -> ProgData.getInstance().proposeList.getFilmDataList().add((FilmDataMTP)f));
    }
}

