/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.offer;

import de.p2tools.mtplayer.controller.data.offer.OfferData;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class OfferList
extends SimpleListProperty<OfferData>
implements P2DataList<OfferData> {
    public static final String TAG = "OfferList";
    private final ObservableList<OfferData> undoList = FXCollections.observableArrayList();

    public OfferList() {
        super(FXCollections.observableArrayList());
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Filter-Vorschl\u00e4ge";
    }

    @Override
    public OfferData getNewItem() {
        return new OfferData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(OfferData.class)) {
            this.add((OfferData)obj);
        }
    }

    public void init() {
        this.addDataToUndoList(this);
        this.clear();
        this.add(new OfferData("#:"));
        this.add(new OfferData("#:.*"));
        this.add(new OfferData("#:.*.*"));
        this.add(new OfferData("Nachrichten"));
        this.add(new OfferData("Sport"));
    }

    public int top(int idx, boolean up) {
        int ret;
        OfferData replace = (OfferData)this.remove(idx);
        if (up) {
            this.add(0, replace);
            ret = 0;
        } else {
            this.add(replace);
            ret = this.getSize() - 1;
        }
        return ret;
    }

    public int up(int idx, boolean up) {
        OfferData replace = (OfferData)this.remove(idx);
        int neu = idx;
        if (up) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, replace);
        return neu;
    }

    public ObservableList<OfferData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addDataToUndoList(List<OfferData> list) {
        this.undoList.clear();
        this.undoList.addAll((Collection<OfferData>)list);
    }

    public synchronized void undoData() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.addAll(this.undoList);
        this.undoList.clear();
    }
}

