/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.mediacleaningdata;

import de.p2tools.mtplayer.controller.data.mediacleaningdata.MediaCleaningData;
import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.config.Config_stringProp;
import de.p2tools.p2lib.configfile.pdata.P2DataSample;
import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class MediaCleaningDataProps
extends P2DataSample<MediaCleaningDataProps> {
    public static final String TAG = "MediaCleaningData";
    private final StringProperty cleaningData = new SimpleStringProperty("");
    private final StringProperty codePoint = new SimpleStringProperty("");

    public MediaCleaningDataProps() {
        this.cleaningData.addListener((u, o, n) -> this.makeUtfCodePoint());
    }

    @Override
    public Config[] getConfigsArr() {
        ArrayList<Config_stringProp> list = new ArrayList<Config_stringProp>();
        list.add(new Config_stringProp("cleaningData", this.cleaningData));
        return list.toArray(new Config[0]);
    }

    public MediaCleaningData getCopy() {
        MediaCleaningData data = new MediaCleaningData();
        data.setCleaningData(this.cleaningData.getValueSafe());
        data.setCodePoint(this.codePoint.getValueSafe());
        return data;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    public String getCleaningData() {
        return (String)this.cleaningData.get();
    }

    public StringProperty cleaningDataProperty() {
        return this.cleaningData;
    }

    public void setCleaningData(String cleaningData) {
        this.cleaningData.set(cleaningData);
        this.makeUtfCodePoint();
    }

    public String getCodePoint() {
        return (String)this.codePoint.get();
    }

    public StringProperty codePointProperty() {
        return this.codePoint;
    }

    public void setCodePoint(String codePoint) {
        this.codePoint.set(codePoint);
    }

    public void makeUtfCodePoint() {
        Object s = "";
        char[] chars = this.cleaningData.getValueSafe().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i > 0) {
                s = (String)s + ", ";
            }
            s = (String)s + Character.codePointAt(chars, i);
        }
        this.codePoint.setValue((String)s);
    }
}

