/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.film;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmSaveFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.starter.RuntimeExecPlay;
import de.p2tools.mtplayer.gui.dialog.NoSetDialogController;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.List;

public class FilmPlayFactory {
    private FilmPlayFactory() {
    }

    public static void playUrl(DownloadData download) {
        FilmDataMTP film = new FilmDataMTP();
        film.arr[14] = download.getUrl();
        film.arr[18] = "";
        FilmPlayFactory.playFilm(download.isAudio(), film);
    }

    public static void playFilmListWithSet(boolean audio, SetData psetData, List<FilmDataMTP> list) {
        if (list.isEmpty()) {
            return;
        }
        if (psetData.isPlay()) {
            FilmPlayFactory.play(audio, list);
            return;
        }
        if (psetData.isSaveAbo()) {
            FilmSaveFactory.saveFilmList(audio, list, psetData);
            return;
        }
        ProgData.getInstance().startDownload.startUrlWithProgram(audio, list.get(0), psetData);
    }

    public static synchronized void playFilmList(boolean audio, ArrayList<FilmDataMTP> list) {
        if (list.isEmpty()) {
            return;
        }
        FilmPlayFactory.play(audio, list);
    }

    public static synchronized void playFilm(boolean audio, FilmDataMTP mtp) {
        if (mtp != null) {
            ArrayList<FilmDataMTP> list = new ArrayList<FilmDataMTP>();
            list.add(mtp);
            FilmPlayFactory.play(audio, list);
        }
    }

    private static void play(boolean audio, List<FilmDataMTP> filmList) {
        RuntimeExecPlay runtimeExec;
        Process process;
        SetData setData = ProgData.getInstance().setDataList.getSetDataPlay();
        if (setData == null) {
            new NoSetDialogController(ProgData.getInstance(), NoSetDialogController.TEXT.PLAY);
            return;
        }
        DownloadData downloadData = new DownloadData(audio, filmList, setData);
        ArrayList<String> list = new ArrayList<String>();
        FilmPlayFactory.startMsg(downloadData, list);
        if (!ProgConfig.DOWNLOAD_ONLY_HISTORY.get()) {
            ProgData.getInstance().historyList.addFilmDataListToHistory(filmList);
        }
        if ((process = (runtimeExec = new RuntimeExecPlay(downloadData)).exec(true)) != null) {
            list.add("Film wurde gestartet");
        } else {
            list.add("Film konnte nicht gestartet werden");
            P2Alert.showErrorAlert("Film starten", "Kann den Film mit dem Aufruf nicht starten:\n\n------------------------------------------------\n" + downloadData.getProgramCall() + "\n------------------------------------------------\n\nBitte im Programmmen\u00fc unter\n -> Einstellungen -> Aufzeichnen und Abspielen \ndie Einstellungen zum Abspielen und Aufzeichnen von Filmen pr\u00fcfen.");
        }
        list.add("------------------------------------------------------------");
        P2Log.sysLog(list.toArray(new String[0]));
    }

    static void startMsg(DownloadData downloadData, ArrayList<String> list) {
        list.add("============================================================");
        list.add("Film abspielen");
        list.add("URL: " + downloadData.getUrl());
        list.add("Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(new P2Date()));
        list.add("Programmaufruf: " + downloadData.getProgramCall());
        list.add("Programmaufruf[]: " + downloadData.getProgramCallArray());
        list.add("------------------------------------------------------------");
    }
}

