/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.file.P2FileSize;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.util.StringConverter;

public class DownloadInfosFactory {
    private static final String SEPARATOR = "  ||  ";
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);
    private static final ProgData progData = ProgData.getInstance();
    private static final DecimalFormat f1 = new DecimalFormat("##");
    private static final DecimalFormat f2 = new DecimalFormat("##.0");

    private DownloadInfosFactory() {
    }

    public static synchronized String getStatusInfosFilm() {
        int sumFilmlist = DownloadInfosFactory.progData.filmList.size();
        int sumFilmShown = DownloadInfosFactory.progData.filmGuiController.getFilmCount();
        String sumFilmlistStr = numberFormat.format(sumFilmShown);
        String sumFilmShownStr = numberFormat.format(sumFilmlist);
        Object textLinks = sumFilmShown == 1 ? "1 Film" : sumFilmlistStr + " Filme";
        if (sumFilmlist != sumFilmShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumFilmShownStr + " )";
        }
        if (DownloadInfosFactory.progData.downloadInfos.getAmount() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = DownloadInfosFactory.progData.downloadInfos.getAmount() == 1 ? (String)textLinks + "1 Download" : (String)textLinks + DownloadInfosFactory.progData.downloadInfos.getAmount() + " Downloads";
            textLinks = (String)textLinks + ": ";
            textLinks = (String)textLinks + DownloadInfosFactory.getRunningDownloadsInfos();
        }
        return textLinks;
    }

    public static synchronized String getStatusInfosAudio() {
        int sumFilmlist = DownloadInfosFactory.progData.audioList.size();
        int sumFilmShown = DownloadInfosFactory.progData.audioGuiController.getFilmCount();
        String sumFilmlistStr = numberFormat.format(sumFilmShown);
        String sumFilmShownStr = numberFormat.format(sumFilmlist);
        Object textLinks = sumFilmShown == 1 ? "1 Audio" : sumFilmlistStr + " Audios";
        if (sumFilmlist != sumFilmShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumFilmShownStr + " )";
        }
        if (DownloadInfosFactory.progData.downloadInfos.getAmount() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = DownloadInfosFactory.progData.downloadInfos.getAmount() == 1 ? (String)textLinks + "1 Download" : (String)textLinks + DownloadInfosFactory.progData.downloadInfos.getAmount() + " Downloads";
            textLinks = (String)textLinks + ": ";
            textLinks = (String)textLinks + DownloadInfosFactory.getRunningDownloadsInfos();
        }
        return textLinks;
    }

    public static synchronized String getStatusInfosLiveFilm() {
        int sumFilmlist = DownloadInfosFactory.progData.liveFilmFilterWorker.getLiveFilmList().size();
        int sumFilmShown = DownloadInfosFactory.progData.liveFilmGuiController.getFilmCount();
        String sumFilmlistStr = numberFormat.format(sumFilmShown);
        String sumFilmShownStr = numberFormat.format(sumFilmlist);
        Object textLinks = sumFilmShown == 1 ? "1 Film" : sumFilmlistStr + " Filme";
        if (sumFilmlist != sumFilmShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumFilmShownStr + " )";
        }
        if (DownloadInfosFactory.progData.downloadInfos.getAmount() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = DownloadInfosFactory.progData.downloadInfos.getAmount() == 1 ? (String)textLinks + "1 Download" : (String)textLinks + DownloadInfosFactory.progData.downloadInfos.getAmount() + " Downloads";
            textLinks = (String)textLinks + ": ";
            textLinks = (String)textLinks + DownloadInfosFactory.getRunningDownloadsInfos();
        }
        return textLinks;
    }

    public static String getStatusInfosDownload() {
        String sumDownloadListStr = numberFormat.format(DownloadInfosFactory.progData.downloadList.size());
        String sumDownloadsShownStr = numberFormat.format(DownloadInfosFactory.progData.downloadGuiController.getDownloadsShown());
        Object textLinks = DownloadInfosFactory.progData.downloadGuiController.getDownloadsShown() == 1 ? "1 Download" : sumDownloadsShownStr + " Downloads";
        if (DownloadInfosFactory.progData.downloadList.size() != DownloadInfosFactory.progData.downloadGuiController.getDownloadsShown()) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumDownloadListStr;
            if (DownloadInfosFactory.progData.downloadInfos.getPlacedBack() >= 1) {
                textLinks = (String)textLinks + ", zur\u00fcckgestellt: " + numberFormat.format(DownloadInfosFactory.progData.downloadInfos.getPlacedBack());
            }
            textLinks = (String)textLinks + ")";
        }
        if (DownloadInfosFactory.progData.downloadInfos.getAmountAbo() > 0 && DownloadInfosFactory.progData.downloadInfos.getAmountDownload() == 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + "nur aus Abos";
        } else if (DownloadInfosFactory.progData.downloadInfos.getAmountAbo() == 0 && DownloadInfosFactory.progData.downloadInfos.getAmountDownload() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + "nur direkte Downloads";
        } else if (DownloadInfosFactory.progData.downloadInfos.getAmountAbo() > 0 && DownloadInfosFactory.progData.downloadInfos.getAmountDownload() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + numberFormat.format(DownloadInfosFactory.progData.downloadInfos.getAmountAbo()) + " aus Abos, ";
            if (DownloadInfosFactory.progData.downloadInfos.getAmountDownload() == 1) {
                textLinks = (String)textLinks + "1 direkter Download";
            } else if (DownloadInfosFactory.progData.downloadInfos.getAmountDownload() > 1) {
                textLinks = (String)textLinks + numberFormat.format(DownloadInfosFactory.progData.downloadInfos.getAmountDownload()) + " direkte Downloads";
            }
        }
        if (DownloadInfosFactory.progData.downloadInfos.getAmount() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + DownloadInfosFactory.getRunningDownloadsInfos();
        }
        if (ProgConfig.DOWNLOAD_MAX_BANDWIDTH_BYTE.getValue() > 0) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + "Max. Bandbreite: " + DownloadInfosFactory.getTextBandwidth();
        }
        return textLinks;
    }

    public static String getStatusInfosAbo() {
        int countOn = 0;
        int countOff = 0;
        int sumAboList = DownloadInfosFactory.progData.aboList.size();
        int sumAboShown = DownloadInfosFactory.progData.aboGuiController.getAboCount();
        for (AboData abo : DownloadInfosFactory.progData.aboList) {
            if (abo.isActive()) {
                ++countOn;
                continue;
            }
            ++countOff;
        }
        String sumAboListStr = numberFormat.format(sumAboList);
        String sumAboShownStr = numberFormat.format(sumAboShown);
        Object textLinks = sumAboShown == 1 ? "1 Abo" : sumAboShownStr + " Abos";
        if (sumAboList != sumAboShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumAboListStr;
            textLinks = (String)textLinks + ")";
        }
        textLinks = (String)textLinks + SEPARATOR + countOn + " eingeschaltet, " + countOff + " ausgeschaltet";
        return textLinks;
    }

    private static synchronized String getRunningDownloadsInfos() {
        Object textLinks = "";
        textLinks = DownloadInfosFactory.progData.downloadInfos.getLoading() == 1 ? (String)textLinks + "1 l\u00e4uft" : (String)textLinks + DownloadInfosFactory.progData.downloadInfos.getLoading() + " laufen";
        if (DownloadInfosFactory.progData.downloadInfos.getLoading() > 0) {
            textLinks = (String)textLinks + " (" + DownloadInfosFactory.progData.downloadInfos.getBandwidthStr() + ")";
        }
        textLinks = DownloadInfosFactory.progData.downloadInfos.getStartedNotLoading() == 1 ? (String)textLinks + ", 1 wartet" : (String)textLinks + ", " + numberFormat.format(DownloadInfosFactory.progData.downloadInfos.getStartedNotLoading()) + " warten";
        if (DownloadInfosFactory.progData.downloadInfos.getFinishedOk() > 0) {
            textLinks = DownloadInfosFactory.progData.downloadInfos.getFinishedOk() == 1 ? (String)textLinks + ", 1 fertig" : (String)textLinks + ", " + numberFormat.format(DownloadInfosFactory.progData.downloadInfos.getFinishedOk()) + " fertig";
        }
        if (DownloadInfosFactory.progData.downloadInfos.getFinishedError() > 0) {
            textLinks = DownloadInfosFactory.progData.downloadInfos.getFinishedError() == 1 ? (String)textLinks + ", 1 fehlerhaft" : (String)textLinks + ", " + numberFormat.format(DownloadInfosFactory.progData.downloadInfos.getFinishedError()) + " fehlerhaft";
        }
        return textLinks;
    }

    public static synchronized String getTrayInfo() {
        if (DownloadInfosFactory.progData.downloadList.isEmpty()) {
            return "keine Downloads";
        }
        Object text1 = DownloadInfosFactory.getInfoText();
        text1 = (String)text1 + P2LibConst.LINE_SEPARATOR;
        text1 = (String)text1 + "laufende Downloads: ";
        if (DownloadInfosFactory.progData.downloadInfos.getByteLoadingDownloads() > 0L || DownloadInfosFactory.progData.downloadInfos.getByteLoadingDownloadsAlreadyLoaded() > 0L) {
            text1 = DownloadInfosFactory.progData.downloadInfos.getByteLoadingDownloads() > 0L ? (String)text1 + P2FileSize.convertToStr(DownloadInfosFactory.progData.downloadInfos.getByteLoadingDownloadsAlreadyLoaded()) + " von " + P2FileSize.convertToStr(DownloadInfosFactory.progData.downloadInfos.getByteLoadingDownloads()) : (String)text1 + P2FileSize.convertToStr(DownloadInfosFactory.progData.downloadInfos.getByteLoadingDownloadsAlreadyLoaded());
            text1 = (String)text1 + ", " + DownloadInfosFactory.progData.downloadInfos.getBandwidthStr();
        }
        text1 = (String)text1 + P2LibConst.LINE_SEPARATOR;
        text1 = (String)text1 + "wartende Downloads: ";
        if (DownloadInfosFactory.progData.downloadInfos.getByteWaitingDownloads() > 0L) {
            text1 = (String)text1 + P2FileSize.convertToStr(DownloadInfosFactory.progData.downloadInfos.getByteWaitingDownloads());
        }
        return text1;
    }

    private static String getInfoText() {
        String text1 = "Downloads: " + DownloadInfosFactory.progData.downloadList.size();
        if (!DownloadInfosFactory.progData.downloadList.isEmpty()) {
            Object txt = ", (";
            if (DownloadInfosFactory.progData.downloadInfos.getPlacedBack() != 0) {
                txt = (String)txt + DownloadInfosFactory.progData.downloadInfos.getPlacedBack() + " zur\u00fcckgestellt, ";
            }
            txt = DownloadInfosFactory.progData.downloadInfos.getLoading() == 1 ? (String)txt + "1 l\u00e4uft" : (String)txt + DownloadInfosFactory.progData.downloadInfos.getLoading() + " laufen";
            txt = DownloadInfosFactory.progData.downloadInfos.getStartedNotLoading() == 1 ? (String)txt + ", 1 wartet" : (String)txt + ", " + DownloadInfosFactory.progData.downloadInfos.getStartedNotLoading() + " warten";
            if (DownloadInfosFactory.progData.downloadInfos.getFinishedOk() > 0) {
                txt = DownloadInfosFactory.progData.downloadInfos.getFinishedOk() == 1 ? (String)txt + ", 1 fertig" : (String)txt + ", " + DownloadInfosFactory.progData.downloadInfos.getFinishedOk() + " fertig";
            }
            if (DownloadInfosFactory.progData.downloadInfos.getFinishedError() > 0) {
                txt = DownloadInfosFactory.progData.downloadInfos.getFinishedError() == 1 ? (String)txt + ", 1 fehlerhaft" : (String)txt + ", " + DownloadInfosFactory.progData.downloadInfos.getFinishedError() + " fehlerhaft";
            }
            txt = (String)txt + ")";
            text1 = text1 + (String)txt;
        }
        return text1;
    }

    public static void initBandwidth(Slider slider, Label lbl) {
        slider.setMin(0.0);
        slider.setMax(1.0E7);
        slider.setShowTickLabels(true);
        slider.setMinorTickCount(19);
        slider.setMajorTickUnit(2000000.0);
        slider.setBlockIncrement(100000.0);
        slider.setSnapToTicks(true);
        slider.setLabelFormatter(new StringConverter<Double>(){

            @Override
            public String toString(Double x) {
                if (x == 0.0) {
                    return "alles";
                }
                return f1.format(x / 1000000.0);
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
        slider.valueProperty().bindBidirectional(ProgConfig.DOWNLOAD_MAX_BANDWIDTH_BYTE);
        lbl.setText(DownloadInfosFactory.getTextBandwidth());
        slider.valueProperty().addListener((obs, oldValue, newValue) -> {
            ProgData.FILMLIST_IS_DOWNLOADING.setValue(false);
            lbl.setText(DownloadInfosFactory.getTextBandwidth());
        });
    }

    private static String getTextBandwidth() {
        double bandwidthByte = ProgConfig.DOWNLOAD_MAX_BANDWIDTH_BYTE.getValue().intValue();
        Object ret = bandwidthByte == 0.0 ? "alles" : (bandwidthByte < 1000000.0 ? f1.format(bandwidthByte / 1000.0) + " kB/s" : (bandwidthByte == 1.0E7 ? f1.format(bandwidthByte / 1000000.0) + " MB/s" : f2.format(bandwidthByte / 1000000.0) + " MB/s"));
        return ret;
    }
}

