/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.SizeTools;
import de.p2tools.mtplayer.controller.data.download.DownloadConstants;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import java.text.DecimalFormat;

public class DownloadInfos {
    private int placedBack = 0;
    private int amount = 0;
    private int amountAbo = 0;
    private int amountDownload = 0;
    private int notStarted = 0;
    private int started = 0;
    private int loadingM3u8 = 0;
    private int startedNotLoading = 0;
    private int loading = 0;
    private int finishedOk = 0;
    private int finishedError = 0;
    private int numberNotStartedDownloads = 0;
    private int numberWaitingDownloads = 0;
    private int numberLoadingDownloads = 0;
    private long byteNotStartedDownloads = 0L;
    private long byteWaitingDownloads = 0L;
    private long byteLoadingDownloads = 0L;
    private long byteLoadingDownloadsAlreadyLoaded = 0L;
    private long timeLeftNotStartedDownloads = 0L;
    private long timeLeftWaitingDownloads = 0L;
    private long timeLeftLoadingDownloads = 0L;
    private long bandwidth = 0L;
    private String bandwidthStr = "";
    private int percent = -1;
    private final ProgData progData;

    public DownloadInfos(ProgData progData) {
        this.progData = progData;
        progData.pEventHandler.addListener(new P2Listener(P2Events.EVENT_TIMER_SECOND){

            @Override
            public void pingGui() {
                DownloadInfos.this.clean();
                DownloadInfos.this.generateDownloadInfos();
                DownloadInfos.this.generateBandwidthInfo();
            }
        });
    }

    public int getPlacedBack() {
        return this.placedBack;
    }

    public synchronized int getAmount() {
        return this.amount;
    }

    public synchronized int getAmountAbo() {
        return this.amountAbo;
    }

    public int getNotStarted() {
        return this.notStarted;
    }

    public synchronized int getStarted() {
        return this.started;
    }

    public synchronized int getAmountDownload() {
        return this.amountDownload;
    }

    public synchronized int getStartedNotLoading() {
        return this.startedNotLoading;
    }

    public synchronized int getLoading() {
        return this.loading;
    }

    public int getLoadingM3u8() {
        return this.loadingM3u8;
    }

    public synchronized int getFinishedOk() {
        return this.finishedOk;
    }

    public synchronized int getFinishedError() {
        return this.finishedError;
    }

    public int getNumberNotStartedDownloads() {
        return this.numberNotStartedDownloads;
    }

    public int getNumberWaitingDownloads() {
        return this.numberWaitingDownloads;
    }

    public int getNumberLoadingDownloads() {
        return this.numberLoadingDownloads;
    }

    public long getByteNotStartedDownloads() {
        return this.byteNotStartedDownloads;
    }

    public long getByteWaitingDownloads() {
        return this.byteWaitingDownloads;
    }

    public long getByteLoadingDownloads() {
        return this.byteLoadingDownloads;
    }

    public long getByteLoadingDownloadsAlreadyLoaded() {
        return this.byteLoadingDownloadsAlreadyLoaded;
    }

    public long getTimeLeftNotStartedDownloads() {
        return this.timeLeftNotStartedDownloads;
    }

    public long getTimeLeftWaitingDownloads() {
        return this.timeLeftWaitingDownloads;
    }

    public long getTimeLeftLoadingDownloads() {
        return this.timeLeftLoadingDownloads;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public String getBandwidthStr() {
        return this.bandwidthStr;
    }

    public int getPercent() {
        return this.percent;
    }

    public String getTimeLeftNotStarted() {
        return DownloadConstants.getTextTimeLeft(this.timeLeftNotStartedDownloads);
    }

    public String getTimeLeftWaiting() {
        return DownloadConstants.getTextTimeLeft(this.timeLeftWaitingDownloads);
    }

    public String getTimeLeftLoading() {
        return DownloadConstants.getTextTimeLeft(this.timeLeftLoadingDownloads);
    }

    private synchronized void generateDownloadInfos() {
        for (DownloadData download : this.progData.downloadList) {
            if (download.isPlacedBack()) {
                ++this.placedBack;
            } else {
                ++this.amount;
            }
            if (download.isAbo()) {
                ++this.amountAbo;
            } else {
                ++this.amountDownload;
            }
            if (download.isStarted() || download.isFinishedOrError()) {
                if (!download.getSource().equals("Abo") && !download.getSource().equals("Download")) continue;
                ++this.started;
                if (download.isStateStartedWaiting()) {
                    ++this.startedNotLoading;
                    continue;
                }
                if (download.isStateStartedRun()) {
                    ++this.loading;
                    if (!download.getUrl().endsWith("m3u8")) continue;
                    ++this.loadingM3u8;
                    continue;
                }
                if (download.isStateFinished()) {
                    ++this.finishedOk;
                    continue;
                }
                if (!download.isStateError()) continue;
                ++this.finishedError;
                continue;
            }
            if (download.isPlacedBack()) continue;
            ++this.notStarted;
        }
    }

    private synchronized void generateBandwidthInfo() {
        for (DownloadData download : this.progData.downloadList) {
            if (download.isStateInit()) {
                ++this.numberNotStartedDownloads;
                this.byteNotStartedDownloads += download.getDownloadSize().getTargetSize() > 0L ? download.getDownloadSize().getTargetSize() : 0L;
                continue;
            }
            if (download.isStateStartedWaiting()) {
                ++this.numberWaitingDownloads;
                this.byteWaitingDownloads += download.getDownloadSize().getTargetSize() > 0L ? download.getDownloadSize().getTargetSize() : 0L;
                continue;
            }
            if (!download.isStateStartedRun()) continue;
            ++this.numberLoadingDownloads;
            this.byteLoadingDownloads += download.getDownloadSize().getTargetSize() > 0L ? download.getDownloadSize().getTargetSize() : 0L;
            this.bandwidth += download.getBandwidth();
            if (this.bandwidth < 0L) {
                this.bandwidth = 0L;
            }
            this.byteLoadingDownloadsAlreadyLoaded += download.getDownloadSize().getActuallySize() > 0L ? download.getDownloadSize().getActuallySize() : 0L;
            if (download.getDownloadStartDto().getTimeLeftSeconds() <= this.timeLeftLoadingDownloads) continue;
            this.timeLeftLoadingDownloads = download.getDownloadStartDto().getTimeLeftSeconds();
        }
        if (this.byteLoadingDownloads < this.byteLoadingDownloadsAlreadyLoaded) {
            this.byteLoadingDownloads = this.byteLoadingDownloadsAlreadyLoaded;
        }
        if (this.bandwidth > 0L) {
            this.timeLeftWaitingDownloads = this.byteWaitingDownloads <= 0L ? 0L : this.byteWaitingDownloads / this.bandwidth;
            this.timeLeftNotStartedDownloads = this.byteNotStartedDownloads <= 0L ? 0L : this.byteNotStartedDownloads / this.bandwidth;
        }
        if (this.byteLoadingDownloads > 0L) {
            this.percent = (int)(this.byteLoadingDownloadsAlreadyLoaded * 100L / this.byteLoadingDownloads);
            this.progressMsg();
        }
        this.roundBandwidth();
    }

    private synchronized void clean() {
        this.placedBack = 0;
        this.amount = 0;
        this.amountAbo = 0;
        this.amountDownload = 0;
        this.notStarted = 0;
        this.started = 0;
        this.startedNotLoading = 0;
        this.loadingM3u8 = 0;
        this.loading = 0;
        this.finishedOk = 0;
        this.finishedError = 0;
        this.numberNotStartedDownloads = 0;
        this.numberWaitingDownloads = 0;
        this.numberLoadingDownloads = 0;
        this.byteNotStartedDownloads = 0L;
        this.byteWaitingDownloads = 0L;
        this.byteLoadingDownloads = 0L;
        this.byteLoadingDownloadsAlreadyLoaded = 0L;
        this.timeLeftNotStartedDownloads = 0L;
        this.timeLeftWaitingDownloads = 0L;
        this.timeLeftLoadingDownloads = 0L;
        this.bandwidth = 0L;
        this.percent = -1;
    }

    private void progressMsg() {
        if (!ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_PROGRESS.getValue().booleanValue()) {
            return;
        }
        int progress = this.percent;
        if (progress >= 0) {
            int i;
            Object text = "  [ ";
            int a = progress / 10;
            for (i = 0; i < a; ++i) {
                text = (String)text + "#";
            }
            for (i = 0; i < 10 - a; ++i) {
                text = (String)text + "-";
            }
            text = (String)text + " ]  " + SizeTools.getSize(this.byteLoadingDownloadsAlreadyLoaded) + " von " + SizeTools.getSize(this.byteLoadingDownloads) + " MByte /";
            text = (String)text + " Downloads: " + this.numberLoadingDownloads + " /";
            text = (String)text + " Bandbreite: " + this.roundBandwidth();
            P2Log.progress((String)text);
        }
    }

    private String roundBandwidth() {
        this.bandwidthStr = (double)this.bandwidth > 1000000.0 ? new DecimalFormat("####0.00").format((double)this.bandwidth / 1000000.0) + " MB/s" : ((double)this.bandwidth > 1000.0 ? Math.round((double)this.bandwidth / 1000.0) + " kB/s" : Math.round(this.bandwidth) + " B/s");
        return this.bandwidthStr;
    }
}

