/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryDelDownloadFiles;
import de.p2tools.mtplayer.controller.data.download.DownloadList;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DownloadFactoryStopDownload {
    private DownloadFactoryStopDownload() {
    }

    public static synchronized boolean delDownloads(DownloadList downloadList, ArrayList<DownloadData> list) {
        P2Duration.counterStart("delDownloads");
        if (list == null || list.isEmpty()) {
            return false;
        }
        ProgData.getInstance().startDownload.setPaused();
        if (!DownloadFactoryDelDownloadFiles.stopDownloadAndDeleteFile(list, true)) {
            return false;
        }
        ProgData.getInstance().downloadList.addDownloadsToUndoList(list);
        ArrayList<DownloadData> aboHistoryList = new ArrayList<DownloadData>();
        for (DownloadData download : list) {
            if (!download.isAbo()) continue;
            aboHistoryList.add(download);
        }
        if (!aboHistoryList.isEmpty()) {
            ProgData.getInstance().historyListAbos.addDownloadDataListToHistory(aboHistoryList);
        }
        downloadList.removeAll((Collection<?>)list);
        P2Duration.counterStop("delDownloads");
        return true;
    }

    public static synchronized boolean stopDownloads(List<DownloadData> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        ProgData.getInstance().startDownload.setPaused();
        return DownloadFactoryDelDownloadFiles.stopDownloadAndDeleteFile(list, false);
    }

    public static synchronized boolean putBackDownloads(ArrayList<DownloadData> list) {
        boolean found = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        ProgData.getInstance().startDownload.setPaused();
        for (DownloadData download : list) {
            if (!download.isStateInit() && !download.isStateStopped()) continue;
            download.putBack();
            found = true;
        }
        return found;
    }

    public static P2Alert.BUTTON restartDownload(int size, String title, P2Alert.BUTTON answer) {
        if (answer.equals((Object)P2Alert.BUTTON.UNKNOWN)) {
            String text = size > 1 ? "Es sind auch fehlerhafte Filme dabei," + P2LibConst.LINE_SEPARATOR + "diese nochmal starten?" : "Film nochmal starten?  ==> " + title;
            answer = P2Alert.showAlert_yes_no_cancel("Download", "Fehlerhafte Downloads", text);
        }
        return answer;
    }
}

