/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.replace.ReplaceFactory;
import de.p2tools.mtplayer.controller.data.setdata.ProgramData;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.gui.configdialog.panesetdata.AboSubDir;
import de.p2tools.p2lib.mediathek.tools.P2FileNameUtils;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.PUrlTools;
import java.io.File;
import java.nio.file.Paths;
import java.util.Date;

public class DownloadFactoryMakeParameter {
    public static final String PARAMETER_URL = "%f";
    public static final String PARAMETER_PATH_FILE = "**";
    public static final String PARAMETER_WEBSITE = "%w";
    public static final String PARAMETER_CHANNEL = "%s";
    public static final String PARAMETER_THEME = "%t";
    public static final String PARAMETER_TITLE = "%T";
    public static final String PARAMETER_DURATION_MINUTE = "%m";
    public static final String PARAMETER_DURATION_MINUTE_000 = "%M";
    public static final String PARAMETER_DEST_PATH = "%a";
    public static final String PARAMETER_DEST_FILE_NAME = "%b";
    public static final String PARAMETER_ORG_FILM_NAME = "%N";
    public static final String PARAMETER_FILM_DATE = "%D";
    public static final String PARAMETER_FILM_TIME = "%d";
    public static final String PARAMETER_TODAY = "%H";
    public static final String PARAMETER_TIME_NOW = "%h";
    public static final String PARAMETER_DAY = "%1";
    public static final String PARAMETER_MONTH = "%2";
    public static final String PARAMETER_YEAR = "%3";
    public static final String PARAMETER_HOUR = "%4";
    public static final String PARAMETER_MINUTE = "%5";
    public static final String PARAMETER_SECOND = "%6";
    public static final String PARAMETER_FILM_NO = "%i";
    public static final String PARAMETER_QUALITY = "%q";
    public static final String PARAMETER_SUFFIX = "%S";
    public static final String PARAMETER_HASH = "%Z";
    public static final String PARAMETER_HASH_SUFFIX = "%z";

    private DownloadFactoryMakeParameter() {
    }

    public static boolean makeProgParameter(DownloadData download) {
        return DownloadFactoryMakeParameter.makeProgParameter(download, download.getAbo(), download.getDestFileName(), download.getDestPath());
    }

    public static boolean makeProgParameter(DownloadData downloadData, AboData abo, String name, String path) {
        try {
            ProgramData programData = downloadData.getSetData().getProgUrl(downloadData.getUrl());
            if (programData == null) {
                return false;
            }
            SetData setData = downloadData.getSetData();
            if (setData.isPlay()) {
                downloadData.setType("Programm");
            } else if (setData.isButton() && !setData.isSaveAbo()) {
                downloadData.setType("Programm");
            } else if (downloadData.getSetData().checkDownloadDirect(downloadData.getUrl())) {
                downloadData.setType("direkter Download");
            } else {
                downloadData.setType("Programm");
            }
            if (downloadData.getType().equals("direkter Download")) {
                downloadData.setProgramName("direkter Download");
            } else {
                downloadData.setProgramName(programData.getName());
            }
            downloadData.setProgramDownloadmanager(programData.isDownManager());
            DownloadFactoryMakeParameter.buildFileNamePath(downloadData, downloadData.getSetData(), abo, name, path);
            DownloadFactoryMakeParameter.buildProgParameter(downloadData, programData);
        }
        catch (Exception ex) {
            P2Log.errorLog(825600145, ex);
        }
        return true;
    }

    private static void buildProgParameter(DownloadData download, ProgramData program) {
        if (download.getType().equals("direkter Download")) {
            download.setProgramCall("");
            download.setProgramCallArray("");
        } else {
            String befehlsString = program.getProgrammAufruf();
            befehlsString = DownloadFactoryMakeParameter.buildUrl(download, befehlsString);
            befehlsString = DownloadFactoryMakeParameter.replaceExec(download, befehlsString);
            download.setProgramCall(befehlsString);
            String progArray = program.getProgrammAufrufArray();
            progArray = DownloadFactoryMakeParameter.buildUrl(download, progArray);
            progArray = DownloadFactoryMakeParameter.replaceExec(download, progArray);
            download.setProgramCallArray(progArray);
        }
    }

    private static void buildFileNamePath(DownloadData download, SetData setData, AboData abo, String selName, String selPath) {
        Object name = DownloadFactoryMakeParameter.buildFileName(download, setData, abo, selName);
        String path = DownloadFactoryMakeParameter.buildFilePath(download, setData, abo, selPath);
        if (path.isEmpty()) {
            path = P2InfoFactory.getStandardDownloadPath();
        }
        if (((String)name).isEmpty()) {
            name = DownloadFactoryMakeParameter.getToday_yyyyMMdd() + "_" + download.getTheme() + "-" + download.getTitle() + ".mp4";
        }
        String[] pathName = new String[]{path, name};
        P2FileUtils.checkLengthPath(pathName);
        download.setFile(Paths.get(path, new String[]{name}).toFile());
    }

    private static String buildFileName(DownloadData download, SetData setData, AboData abo, String selName) {
        Object name;
        if (!selName.isEmpty()) {
            name = selName;
        } else {
            name = abo != null && !abo.getAboFileName().isEmpty() ? abo.getAboFileName() : setData.getDestFileName(download.getUrl());
            if (((String)name).isEmpty()) {
                name = DownloadFactoryMakeParameter.getToday_yyyyMMdd() + "_" + download.getTheme() + "-" + download.getTitle() + ".mp4";
            }
            name = DownloadFactoryMakeParameter.replaceTags(download, (String)name, false);
            String suff = "";
            if (((String)name).contains(".")) {
                suff = ((String)name).substring(((String)name).lastIndexOf("."));
                if (suff.length() <= 4 && suff.length() > 1) {
                    name = ((String)name).substring(0, ((String)name).lastIndexOf("."));
                } else {
                    suff = "";
                }
            }
            name = ReplaceFactory.replaceFileNameWithReplaceList((String)name, false);
            if (((String)(name = (String)name + suff)).length() > 8) {
                String suf1 = ((String)name).substring(((String)name).length() - 8, ((String)name).length() - 4);
                String suf2 = ((String)name).substring(((String)name).length() - 4);
                if (suf1.startsWith(".") && suf2.startsWith(".") && suf1.equalsIgnoreCase(suf2)) {
                    name = ((String)name).substring(0, ((String)name).length() - 4);
                }
            }
            if (setData.getMaxSize() > 0) {
                int length = setData.getMaxSize();
                name = P2FileUtils.cutName((String)name, length);
            }
        }
        return name;
    }

    private static String buildFilePath(DownloadData download, SetData setData, AboData abo, String selPath) {
        String path;
        if (!selPath.isEmpty()) {
            path = selPath;
        } else {
            path = abo != null && !abo.getAboDir().isEmpty() ? abo.getAboDir() : (setData.getDestPath().isEmpty() ? P2InfoFactory.getStandardDownloadPath() : setData.getDestPath());
            if (abo == null && setData.isGenAboSubDir()) {
                path = P2FileUtils.addsPath(path, ReplaceFactory.replaceFileNameWithReplaceList(download.getTheme(), true));
            }
            if (abo != null) {
                download.setAboName(abo.getName());
                if (abo.getAboDir().isEmpty()) {
                    String addPpath = "";
                    if (!abo.getAboSubDir().trim().isEmpty()) {
                        addPpath = abo.getAboSubDir();
                    } else if (setData.isGenAboSubDir()) {
                        AboSubDir.ENSubDir ENSubDir2 = AboSubDir.getENSubDir(setData.getAboSubDir_ENSubDirNo());
                        switch (ENSubDir2) {
                            case TITLE: {
                                addPpath = download.getTitle();
                                break;
                            }
                            case SENDER: {
                                addPpath = download.getChannel();
                                break;
                            }
                            case ABONAME: {
                                addPpath = abo.getName();
                                break;
                            }
                            case SENDEDATUM: {
                                addPpath = download.getFilmDate().get_yyyy_MM_dd();
                                break;
                            }
                            case DOWNLOADDATUM: {
                                addPpath = DownloadFactoryMakeParameter.getToday_yyyy_MM_dd();
                                break;
                            }
                            default: {
                                addPpath = download.getTheme();
                            }
                        }
                    }
                    addPpath = addPpath.trim();
                    if (!addPpath.isEmpty()) {
                        path = P2FileUtils.addsPath(path, P2FileNameUtils.removeIllegalCharacters(addPpath, true));
                    }
                }
            }
        }
        path = DownloadFactoryMakeParameter.replaceTags(download, path, true);
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String replaceTags(DownloadData download, String replStr, boolean andReplace) {
        int length = download.getSetData().getMaxField();
        replStr = replStr.replace(PARAMETER_THEME, DownloadFactoryMakeParameter.setMaxLength(download.getTheme(), length, andReplace));
        replStr = replStr.replace(PARAMETER_TITLE, DownloadFactoryMakeParameter.setMaxLength(download.getTitle(), length, andReplace));
        replStr = replStr.replace(PARAMETER_CHANNEL, DownloadFactoryMakeParameter.setMaxLength(download.getChannel(), length, andReplace));
        replStr = replStr.replace(PARAMETER_ORG_FILM_NAME, DownloadFactoryMakeParameter.setMaxLength(PUrlTools.getFileName(download.getUrl()), length, andReplace));
        StringBuilder duration = new StringBuilder("" + download.getDurationMinute());
        replStr = replStr.replace(PARAMETER_DURATION_MINUTE, duration.toString());
        while (duration.length() < 3) {
            duration.insert(0, "0");
        }
        replStr = replStr.replace(PARAMETER_DURATION_MINUTE_000, duration.toString());
        replStr = replStr.replace(PARAMETER_FILM_DATE, download.getFilmDate().isEmpty() ? DownloadFactoryMakeParameter.getToday_yyyyMMdd() : DownloadFactoryMakeParameter.cleanDate(DownloadFactoryMakeParameter.turnDate(download.getFilmDateStr())));
        replStr = replStr.replace(PARAMETER_FILM_TIME, download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HHMMSS() : DownloadFactoryMakeParameter.cleanDate(download.getFilmTime()));
        replStr = replStr.replace(PARAMETER_TODAY, DownloadFactoryMakeParameter.getToday_yyyyMMdd());
        replStr = replStr.replace(PARAMETER_TIME_NOW, DownloadFactoryMakeParameter.getNow_HHMMSS());
        replStr = replStr.replace(PARAMETER_DAY, DownloadFactoryMakeParameter.getDMY(PARAMETER_DAY, download.getFilmDateStr().isEmpty() ? DownloadFactoryMakeParameter.getToday__yyyy_o_MM_o_dd() : download.getFilmDateStr()));
        replStr = replStr.replace(PARAMETER_MONTH, DownloadFactoryMakeParameter.getDMY(PARAMETER_MONTH, download.getFilmDateStr().isEmpty() ? DownloadFactoryMakeParameter.getToday__yyyy_o_MM_o_dd() : download.getFilmDateStr()));
        replStr = replStr.replace(PARAMETER_YEAR, DownloadFactoryMakeParameter.getDMY(PARAMETER_YEAR, download.getFilmDateStr().isEmpty() ? DownloadFactoryMakeParameter.getToday__yyyy_o_MM_o_dd() : download.getFilmDateStr()));
        replStr = replStr.replace(PARAMETER_HOUR, DownloadFactoryMakeParameter.getHMS(PARAMETER_HOUR, download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HH_MM_SS() : download.getFilmTime()));
        replStr = replStr.replace(PARAMETER_MINUTE, DownloadFactoryMakeParameter.getHMS(PARAMETER_MINUTE, download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HH_MM_SS() : download.getFilmTime()));
        replStr = replStr.replace(PARAMETER_SECOND, DownloadFactoryMakeParameter.getHMS(PARAMETER_SECOND, download.getFilmTime().isEmpty() ? DownloadFactoryMakeParameter.getNow_HH_MM_SS() : download.getFilmTime()));
        replStr = replStr.replace(PARAMETER_FILM_NO, String.valueOf(download.getFilmNo()));
        String res = "";
        if (download.getUrl().equals(download.getUrlForResolution("normal"))) {
            res = "H";
        } else if (download.getUrl().equals(download.getUrlForResolution("hd"))) {
            res = "HD";
        } else if (download.getUrl().equals(download.getUrlForResolution("small"))) {
            res = "L";
        }
        replStr = replStr.replace(PARAMETER_QUALITY, res);
        replStr = replStr.replace(PARAMETER_SUFFIX, PUrlTools.getSuffixFromUrl(download.getUrl()));
        replStr = replStr.replace(PARAMETER_HASH, P2FileUtils.getHash(download.getUrl()));
        replStr = replStr.replace(PARAMETER_HASH_SUFFIX, P2FileUtils.getHash(download.getUrl()) + "." + PUrlTools.getSuffixFromUrl(download.getUrl()));
        return replStr;
    }

    private static String setMaxLength(String name, int length, boolean andReplace) {
        if (andReplace) {
            name = ReplaceFactory.replaceFileNameWithReplaceList(name, false);
        }
        if (length <= 0) {
            return name;
        }
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        return name;
    }

    private static String getNow_HHMMSS() {
        return P2DateConst.F_FORMAT_HHmmss.format(new Date());
    }

    private static String getNow_HH_MM_SS() {
        return P2DateConst.F_FORMAT_HH__mm__ss.format(new Date());
    }

    private static String getToday_yyyyMMdd() {
        return P2DateConst.F_FORMAT_yyyyMMdd.format(new Date());
    }

    private static String getToday_yyyy_MM_dd() {
        return P2DateConst.F_FORMAT_yyyy_MM_dd.format(new Date());
    }

    private static String getToday__yyyy_o_MM_o_dd() {
        return P2DateConst.F_FORMAT_dd_MM_yyyy.format(new Date());
    }

    private static String getDMY(String s, String datum) {
        String ret = "";
        if (!datum.isEmpty()) {
            try {
                if (datum.length() == 10) {
                    switch (s) {
                        case "%1": {
                            ret = datum.substring(0, 2);
                            break;
                        }
                        case "%2": {
                            ret = datum.substring(3, 5);
                            break;
                        }
                        case "%3": {
                            ret = datum.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(775421006, ex, datum);
            }
        }
        return ret;
    }

    private static String getHMS(String s, String zeit) {
        String ret = "";
        if (!zeit.isEmpty()) {
            try {
                if (zeit.length() == 8) {
                    switch (s) {
                        case "%4": {
                            ret = zeit.substring(0, 2);
                            break;
                        }
                        case "%5": {
                            ret = zeit.substring(3, 5);
                            break;
                        }
                        case "%6": {
                            ret = zeit.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(775421006, ex, zeit);
            }
        }
        return ret;
    }

    private static String turnDate(String date) {
        Object ret = "";
        if (!date.isEmpty()) {
            try {
                if (date.length() == 10) {
                    Object tmp = date.substring(6);
                    tmp = (String)tmp + "." + date.substring(3, 5);
                    ret = tmp = (String)tmp + "." + date.substring(0, 2);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(775421006, ex, date);
            }
        }
        return ret;
    }

    private static String cleanDate(String date) {
        String ret = date;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }

    private static String buildUrl(DownloadData downloadData, String execString) {
        if (downloadData.getUrlList().size() <= 1) {
            return execString.replace(PARAMETER_URL, downloadData.getUrl());
        }
        String TRENNER = execString.contains("<>") ? "<>" : " ";
        StringBuilder url = new StringBuilder();
        boolean append = false;
        for (String u : downloadData.getUrlList()) {
            if (!append) {
                append = true;
            } else {
                url.append(TRENNER);
            }
            url.append(u);
        }
        return execString.replace(PARAMETER_URL, url);
    }

    private static String replaceExec(DownloadData downloadData, String execString) {
        execString = execString.replace(PARAMETER_PATH_FILE, downloadData.getDestPathFile());
        execString = execString.replace(PARAMETER_WEBSITE, downloadData.getUrlWebsite());
        execString = execString.replace(PARAMETER_THEME, downloadData.getTheme());
        execString = execString.replace(PARAMETER_TITLE, downloadData.getTitle());
        execString = execString.replace(PARAMETER_CHANNEL, downloadData.getChannel());
        execString = execString.replace(PARAMETER_DEST_PATH, downloadData.getDestPath());
        execString = execString.replace(PARAMETER_DEST_FILE_NAME, downloadData.getDestFileName());
        return execString;
    }
}

