/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.SizeTools;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadDataProps;
import de.p2tools.mtplayer.controller.data.download.DownloadList;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.scene.control.Label;

public class DownloadFactory {
    private DownloadFactory() {
    }

    public static void preferDownloads(DownloadList downloadList, List<DownloadData> prefDownList) {
        prefDownList.removeIf(d -> d.getState() != 2);
        if (prefDownList.isEmpty()) {
            return;
        }
        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
        for (Object download : downloadList) {
            int i = ((DownloadDataProps)download).getNo();
            if (i >= Integer.MAX_VALUE) continue;
            list.add((DownloadData)download);
        }
        prefDownList.forEach(list::remove);
        list.sort(new Comparator<DownloadData>(){

            @Override
            public int compare(DownloadData d1, DownloadData d2) {
                return d1.getNo() < d2.getNo() ? -1 : 1;
            }
        });
        int addNr = prefDownList.size();
        for (DownloadData download : list) {
            download.setNo(++addNr);
        }
        int i = 1;
        for (DownloadData dataDownload : prefDownList) {
            dataDownload.setNo(i++);
        }
    }

    public static synchronized void cleanUpList(DownloadList downloadList) {
        boolean found = false;
        Iterator it = downloadList.iterator();
        while (it.hasNext()) {
            DownloadData download = (DownloadData)it.next();
            if (download.isStateInit() || download.isStateStopped()) continue;
            if (download.isStateFinished()) {
                it.remove();
                found = true;
                continue;
            }
            if (!download.isStateError()) continue;
            download.resetDownload();
            found = true;
        }
        if (found) {
            downloadList.setDownloadsChanged();
        }
    }

    public static void refreshDownloads(DownloadList downloadList) {
        P2Duration.counterStart("refreshDownloads");
        List syncRemoveList = Collections.synchronizedList(new ArrayList());
        downloadList.stream().filter(d -> !d.isStateStopped()).filter(DownloadData::isAbo).forEach(download -> {
            if (download.isStateInit()) {
                syncRemoveList.add(download);
            } else if (download.isStateError()) {
                syncRemoveList.add(download);
            }
        });
        if (syncRemoveList.size() == downloadList.size()) {
            downloadList.clear();
        } else {
            downloadList.removeAll(syncRemoveList);
        }
        downloadList.resetPlacedBack();
        P2Duration.counterStop("refreshDownloads");
    }

    public static void calculateAndCheckDiskSpace(DownloadData download, String path, Label lblSizeFree) {
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            String noSize = "";
            long usableSpace = P2FileUtils.getFreeDiskSpace(path);
            String sizeFree = "";
            if (usableSpace == 0L) {
                lblSizeFree.setText("");
            } else {
                sizeFree = SizeTools.humanReadableByteCount(usableSpace, true);
            }
            if ((usableSpace /= 1000000L) > 0L) {
                long size = download.getDownloadSize().getTargetSize();
                if ((size /= 1000000L) > usableSpace) {
                    noSize = " [ nicht genug Speicher: ";
                }
            }
            if (noSize.isEmpty()) {
                lblSizeFree.setText(" [ noch frei: " + sizeFree + " ]");
            } else {
                lblSizeFree.setText(noSize + sizeFree + " ]");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setDownloadSize(DownloadData download) {
        String M3U8 = ".m3u8";
        if (download.getFilmSizeHd().isEmpty() && !download.getFilmUrlHd().endsWith(".m3u8")) {
            download.setFilmSizeHd(download.getFilmUrlHd().isEmpty() ? "" : de.p2tools.p2lib.mediathek.download.DownloadFactory.getContentLengthMB(download.getFilmUrlHd()));
        }
        if (download.getFilmSizeSmall().isEmpty() && !download.getFilmUrlSmall().endsWith(".m3u8")) {
            download.setFilmSizeSmall(download.getFilmUrlSmall().isEmpty() ? "" : de.p2tools.p2lib.mediathek.download.DownloadFactory.getContentLengthMB(download.getFilmUrlSmall()));
        }
    }
}

