/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.download;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.download.DownloadDataProps;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadFactoryMakeParameter;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.starter.StartDownloadDto;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.net.PUrlTools;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;

public final class DownloadData
extends DownloadDataProps {
    private StartDownloadDto downloadStartDto = new StartDownloadDto(this);
    private FilmDataMTP film = null;
    private SetData setData = null;
    private AboData abo = null;
    private String errorMessage = "";

    public DownloadData() {
    }

    public DownloadData(boolean audio, List<FilmDataMTP> filmList, SetData setData) {
        this.setAudio(audio);
        this.setFilm(filmList.get(0));
        this.setSetData(setData, true);
        this.setSource("Button");
        this.setUrlSubtitle(this.film.getUrlSubtitle());
        this.setInfoFile(setData.isInfoFile());
        this.setSubtitle(setData.isSubtitle());
        String resolution = ProgData.getInstance().filterWorkerFilm.getActFilterSettings().isOnlyHd() ? "hd" : setData.getResolution();
        this.initResolution(resolution);
        if (filmList.size() > 1) {
            this.getUrlList().clear();
            for (FilmDataMTP filmDataMTP : filmList) {
                this.getUrlList().add(filmDataMTP.getUrlForResolution(resolution));
            }
        }
        DownloadFactoryMakeParameter.makeProgParameter(this, null, "", "");
    }

    public DownloadData(boolean audio, String source2, SetData setData, FilmDataMTP film, AboData abo, String path, String resolution, boolean setSize) {
        this.setAudio(audio);
        this.setFilm(film);
        this.setSetData(setData, true);
        this.setAbo(abo);
        this.setSource(source2);
        if (abo != null && !abo.getStartTime().isEmpty()) {
            this.setStartTimeToday(abo.getStartTime());
        }
        if (setSize) {
            DownloadFactory.setDownloadSize(this);
        }
        if (resolution.isEmpty()) {
            resolution = abo != null ? abo.getResolution() : setData.getResolution();
        }
        this.initResolution(resolution);
        DownloadFactoryMakeParameter.makeProgParameter(this, abo, "", path);
    }

    public boolean isStateInit() {
        return this.getState() == 0;
    }

    public boolean isStateStopped() {
        return this.getState() == 1;
    }

    public boolean isStateStartedWaiting() {
        return this.getState() == 2;
    }

    public boolean isStateStartedRun() {
        return this.getState() == 3;
    }

    public boolean isStateFinished() {
        return this.getState() == 4;
    }

    public boolean isStateError() {
        return this.getState() == 5;
    }

    public void setStateStartedWaiting() {
        this.setState(2);
    }

    public void setStateStartedRun() {
        this.setState(3);
    }

    public void setStateFinished() {
        this.setState(4);
    }

    public void setStateError(String error) {
        if (!error.isEmpty()) {
            this.getDownloadStartDto().addErrMsg(error);
        }
        this.setState(5);
    }

    public boolean isStarted() {
        return this.getState() > 1 && !this.isStateFinished();
    }

    public boolean isNotStartedOrFinished() {
        return this.isStateInit() || this.isStateStopped();
    }

    public boolean isFinishedOrError() {
        return this.getState() >= 4;
    }

    public boolean isAbo() {
        return !this.getAboName().isEmpty();
    }

    public void initResolution() {
        this.initResolution(super.getResolution());
    }

    private void initResolution(String resolution) {
        if (this.film != null) {
            this.setHd(this.film.isHd());
            this.setSmall(this.film.isSmall());
            switch (resolution) {
                case "hd": {
                    if (this.isHd()) break;
                    resolution = "normal";
                    break;
                }
                case "small": {
                    if (this.isSmall()) break;
                    resolution = "normal";
                }
            }
            if (this.isHd()) {
                this.setFilmUrlHd(this.film.getUrlForResolution("hd"));
            } else {
                this.setFilmUrlHd("");
            }
            if (this.isSmall()) {
                this.setFilmUrlSmall(this.film.getUrlForResolution("small"));
            } else {
                this.setFilmUrlSmall("");
            }
            this.setFilmUrlNormal(this.film.getUrlForResolution("normal"));
            this.setFilmSizeNormal(this.film.getFilmSize().toString());
        } else {
            resolution = "normal";
            this.setHd(false);
            this.setSmall(false);
        }
        this.setResolution(resolution);
    }

    @Override
    public void setResolution(String resolution) {
        super.setResolution(resolution);
        switch (resolution) {
            case "hd": {
                this.setUrl(this.getFilmUrlHd());
                this.getDownloadSize().setTargetSize(this.getFilmSizeHd());
                break;
            }
            case "small": {
                this.setUrl(this.getFilmUrlSmall());
                this.getDownloadSize().setTargetSize(this.getFilmSizeSmall());
                break;
            }
            default: {
                this.setUrl(this.getFilmUrlNormal());
                this.getDownloadSize().setTargetSize(this.getFilmSizeNormal());
            }
        }
    }

    public String getUrlForResolution(String resolution) {
        if (resolution.equals("hd")) {
            return this.getFilmUrlHd().isEmpty() ? this.getFilmUrlNormal() : this.getFilmUrlHd();
        }
        if (resolution.equals("small")) {
            return this.getFilmUrlSmall().isEmpty() ? this.getFilmUrlNormal() : this.getFilmUrlSmall();
        }
        return this.getFilmUrlNormal();
    }

    public void initStartDownload() {
        this.getDownloadStartDto().setDeleteAfterStop(false);
        this.getDownloadStartDto().setStartCounter(0);
        this.setBandwidth(0L);
        this.setStateStartedWaiting();
        this.setErrorMessage("");
    }

    public void putBack() {
        this.setPlacedBack(true);
        this.resetDownload();
    }

    public void resetDownload() {
        this.stopDownload(false);
        this.setProgress(-1.0);
        this.setState(0);
    }

    public void stopDownload(boolean deleteAfterStop) {
        this.getDownloadStartDto().setDeleteAfterStop(deleteAfterStop);
        this.stopDownload();
    }

    public void stopDownload() {
        if (!this.isStateError()) {
            this.setProgress(-1.0);
            this.setState(1);
        }
        this.getDownloadSize().resetActFileSize();
        this.setRemaining(Integer.MIN_VALUE);
        this.setBandwidth(0L);
        this.setNo(Integer.MAX_VALUE);
    }

    public StartDownloadDto getDownloadStartDto() {
        return this.downloadStartDto;
    }

    public void setDownloadStartDto(StartDownloadDto startDownloadDto) {
        this.downloadStartDto = startDownloadDto;
    }

    public FilmDataMTP getFilm() {
        return this.film;
    }

    public void setFilm(FilmDataMTP film) {
        if (film == null) {
            this.setFilmNo(Integer.MAX_VALUE);
            return;
        }
        this.film = film;
        this.setFilmNo(film.getNo());
        this.setChannel(film.arr[1]);
        this.setTheme(film.arr[2]);
        this.setTitle(film.arr[3]);
        this.setDescription(film.arr[13]);
        this.setFilmUrlNormal(film.arr[14]);
        this.setFilmUrlHd(film.isHd() ? film.getUrlForResolution("hd") : "");
        this.setFilmUrlSmall(film.isSmall() ? film.getUrlForResolution("small") : "");
        this.setHd(film.isHd());
        this.setSmall(film.isSmall());
        this.setUrlWebsite(film.arr[15]);
        this.setUrlSubtitle(film.getUrlSubtitle());
        this.setUt(film.isUt());
        this.setFilmDate(film.arr[6], film.arr[7]);
        this.setFilmDateStr(film.arr[6]);
        this.setFilmTime(film.arr[7]);
        this.setDurationMinute(film.getDurationMinute());
        this.setHistoryUrl(film.getUrlHistory());
        this.setGeoBlocked(film.isGeoBlocked());
    }

    public AboData getAbo() {
        return this.abo;
    }

    public void setAbo(AboData abo) {
        this.abo = abo;
        if (abo != null) {
            this.setAboName(abo.getName());
        }
    }

    public SetData getSetData() {
        return this.setData;
    }

    public void setSetData(SetData setData, boolean initSetData) {
        this.setData = setData;
        this.setSetDataId(setData.getId());
        if (initSetData) {
            this.setInfoFile(setData.isInfoFile());
            this.setSubtitle(setData.isSubtitle());
        }
    }

    public String getFileNameWithoutSuffix() {
        return PUrlTools.getFileNameWithoutSuffix(this.getDestFileName());
    }

    public String getPathFileNameWithoutSuffix() {
        return PUrlTools.getFileNameWithoutSuffix(this.getDestPathFile());
    }

    public String getFileNameSuffix() {
        return P2FileUtils.getFileNameSuffix(this.getDestPathFile());
    }

    public File getFile() {
        return this.downloadStartDto.getFile();
    }

    public void setFile(File file) {
        this.downloadStartDto.setFile(file);
        this.destFileNameProperty().setValue(file.getName());
        this.destPathProperty().setValue(file.getParent());
        this.destPathFileProperty().setValue(file.getAbsolutePath());
    }

    public void setFile(String path, String name) {
        this.setFile(P2FileUtils.addsPath(path, name));
    }

    public void setFile(String file) {
        this.downloadStartDto.setFile(Path.of(file, new String[0]).toFile());
        String name = this.downloadStartDto.getFile().getName();
        String path = this.downloadStartDto.getFile().getParent();
        String pathFile = this.downloadStartDto.getFile().getAbsolutePath();
        this.destFileNameProperty().setValue(name == null ? "" : name);
        this.destPathProperty().setValue(path == null ? "" : path);
        this.destPathFileProperty().setValue(pathFile == null ? "" : pathFile);
    }

    public void setPathName(String path, String name) {
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            path = P2InfoFactory.getStandardDownloadPath();
        }
        if (((String)name).isEmpty()) {
            name = P2DateConst.F_FORMAT_yyyyMMdd.format(new Date()) + "_" + this.getTheme() + "-" + this.getTitle() + ".mp4";
        }
        String[] pathName = new String[]{path, name};
        P2FileUtils.checkLengthPath(pathName);
        if (!pathName[0].equals(path) || !pathName[1].equals(name)) {
            Platform.runLater(() -> {
                new P2Alert();
                P2Alert.showInfoAlert("Pfad zu lang!", "Pfad zu lang!", "Dateiname war zu lang und wurde gek\u00fcrzt!");
            });
            path = pathName[0];
            name = pathName[1];
        }
        this.setFile(P2FileUtils.addsPath(path, (String)name));
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        String s = "Der Download hatte einen Fehler:\n\n";
        this.errorMessage = "Der Download hatte einen Fehler:\n\n" + errorMessage;
    }

    public DownloadData getCopy() {
        DownloadData downloadData = new DownloadData();
        for (int i = 0; i < this.properties.length; ++i) {
            downloadData.properties[i].setValue(this.properties[i].getValue());
        }
        downloadData.film = this.film;
        downloadData.setDownloadStartDto(this.getDownloadStartDto());
        downloadData.setData = this.setData;
        downloadData.abo = this.abo;
        downloadData.getUrlList().setAll((String[])new String[]{this.getUrl()});
        return downloadData;
    }

    public void copyToMe(DownloadData downloadData) {
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i].setValue(downloadData.properties[i].getValue());
        }
        this.film = downloadData.film;
        this.setDownloadStartDto(downloadData.getDownloadStartDto());
        this.setData = downloadData.setData;
        this.abo = downloadData.abo;
        this.getUrlList().setAll((Collection<String>)downloadData.getUrlList());
    }
}

