/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.cleaningdata;

import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningData;
import de.p2tools.mtplayer.controller.data.cleaningdata.CleaningFactory;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class CleaningDataList
extends SimpleListProperty<CleaningData>
implements P2DataList<CleaningData> {
    public String TAG;
    private final boolean propose;
    private FilteredList<CleaningData> filteredList = null;
    private SortedList<CleaningData> sortedList = null;

    public CleaningDataList(boolean propose) {
        super(FXCollections.observableArrayList());
        this.TAG = propose ? "CleaningDataListPropose" : "CleaningDataListMedia";
        this.propose = propose;
    }

    public void initList() {
        if (this.isEmpty()) {
            for (String s : CleaningFactory.REPLACE_LIST) {
                this.add(new CleaningData(s, true));
            }
            for (String s : CleaningFactory.CLEAN_LIST) {
                this.add(new CleaningData(s, false));
            }
        }
        this.forEach(cl -> cl.setCleaningString(cl.getCleaningString().trim()));
    }

    public SortedList<CleaningData> getSortedList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<CleaningData>(this, p -> true);
            this.sortedList = new SortedList<CleaningData>((ObservableList<CleaningData>)this.filteredList);
        }
        return this.sortedList;
    }

    public FilteredList<CleaningData> getFilteredList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<CleaningData>(this, p -> true);
            this.sortedList = new SortedList<CleaningData>((ObservableList<CleaningData>)this.filteredList);
        }
        return this.filteredList;
    }

    @Override
    public String getTag() {
        return this.TAG;
    }

    @Override
    public String getComment() {
        return this.propose ? "Liste aller ProposeReplaceData" : "Liste aller ProposeCleaningData";
    }

    @Override
    public CleaningData getNewItem() {
        return new CleaningData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(CleaningData.class)) {
            this.add((CleaningData)obj);
        }
    }

    @Override
    public synchronized boolean add(CleaningData b) {
        return super.add(b);
    }
}

