/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.bookmark;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkFileFactoryOld;
import de.p2tools.mtplayer.controller.tools.FileFactory;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigReadFile;
import de.p2tools.p2lib.configfile.ConfigWriteFile;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class BookmarkLoadSaveFactory {
    private BookmarkLoadSaveFactory() {
    }

    public static void loadList() {
        P2Duration.counterStart("loadList");
        if (!ProgConfig.SYSTEM_USE_NEW_BOOKMARK_FILE.get()) {
            ProgConfig.SYSTEM_USE_NEW_BOOKMARK_FILE.set(true);
            BookmarkFileFactoryOld.readBookmarkDataFromFileOld();
            BookmarkLoadSaveFactory.saveBookmark();
            FileFactory.deleteHistoryFile("bookmarks.txt");
        } else {
            BookmarkLoadSaveFactory.loadBookmarks();
        }
        ProgData.getInstance().bookmarkList.fillUrlHash();
        P2Duration.counterStop("loadList");
    }

    private static void loadBookmarks() {
        String settingsDir = ProgInfos.getSettingsDirectory_String();
        String fileName = "bookmarks.xml";
        Path xmlFilePath = FileFactory.getUrlFilePath(settingsDir, fileName);
        try {
            if (!Files.exists(xmlFilePath, new LinkOption[0])) {
                return;
            }
            ConfigFile configFile = new ConfigFile(xmlFilePath.toString(), false);
            configFile.addConfigs(ProgData.getInstance().bookmarkList);
            if (!ConfigReadFile.readConfig(configFile)) {
                P2Log.errorLog(959874512, "Bookmarks konnten nicht geladen werden");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveBookmark() {
        P2Log.sysLog("Bookmarks sichern");
        String settingsDir = ProgInfos.getSettingsDirectory_String();
        String fileName = "bookmarks.xml";
        Path xmlFilePath = FileFactory.getUrlFilePath(settingsDir, fileName);
        ConfigFile configFile = new ConfigFile(xmlFilePath.toString(), false);
        configFile.addConfigs(ProgData.getInstance().bookmarkList);
        ConfigWriteFile.writeConfigFile(configFile);
    }
}

