/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.bookmark;

import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkLoadSaveFactory;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.HashSet;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class BookmarkList
extends SimpleListProperty<BookmarkData>
implements P2DataList<BookmarkData> {
    public static final String TAG = "BookmarkList";
    private final HashSet<String> urlHash = new HashSet();
    private FilteredList<BookmarkData> filteredList = null;
    private SortedList<BookmarkData> sortedList = null;
    private boolean found = false;

    public BookmarkList() {
        super(FXCollections.observableArrayList());
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Bookmarks";
    }

    @Override
    public BookmarkData getNewItem() {
        return new BookmarkData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(BookmarkData.class)) {
            BookmarkData d = (BookmarkData)obj;
            this.addToThisList(d);
        }
    }

    public SortedList<BookmarkData> getSortedList() {
        this.filteredList = this.getFilteredList();
        if (this.sortedList == null) {
            this.sortedList = new SortedList<BookmarkData>((ObservableList<BookmarkData>)this.filteredList);
        }
        return this.sortedList;
    }

    public FilteredList<BookmarkData> getFilteredList() {
        if (this.filteredList == null) {
            this.filteredList = new FilteredList<BookmarkData>(this, p -> true);
        }
        return this.filteredList;
    }

    public void removeUrlHash(HashSet<String> removeUrlHash) {
        ArrayList newList = new ArrayList();
        this.found = false;
        P2Duration.counterStart("Bookmark: removeFromBookmark");
        P2Log.sysLog("Aus Bookmarks l\u00f6schen: " + removeUrlHash.size() + ", l\u00f6schen aus: bookmarks.xml");
        this.forEach(bookmarkData -> {
            if (removeUrlHash.contains(bookmarkData.getUrl())) {
                this.found = true;
            } else {
                newList.add(bookmarkData);
            }
        });
        if (this.found) {
            this.clearList();
            this.addAll(newList);
            this.fillUrlHash();
            BookmarkLoadSaveFactory.saveBookmark();
        }
        P2Duration.counterStop("Bookmark: removeFromBookmark");
    }

    public boolean checkIfUrlAlreadyIn(String urlFilm) {
        return this.urlHash.contains(urlFilm);
    }

    public void clearList() {
        this.urlHash.clear();
        super.clear();
    }

    public void addToThisList(BookmarkData bookmarkData) {
        this.add(bookmarkData);
        this.urlHash.add(bookmarkData.getUrl());
    }

    public void fillUrlHash() {
        this.urlHash.clear();
        this.forEach(bookmarkData -> this.urlHash.add(bookmarkData.getUrl()));
    }
}

