/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.bookmark;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkList;
import de.p2tools.mtplayer.controller.tools.FileFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class BookmarkFileFactoryOld {
    private static final String SEPARATOR_1 = " |#| ";
    private static final String SEPARATOR_2 = "  |###|  ";

    private BookmarkFileFactoryOld() {
    }

    public static synchronized void readBookmarkDataFromFileOld() {
        String fileName = "bookmarks.txt";
        BookmarkList dataList = ProgData.getInstance().bookmarkList;
        String settingsDir = ProgInfos.getSettingsDirectory_String();
        Path urlPath = FileFactory.getUrlFilePath(settingsDir, fileName);
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(urlPath, new OpenOption[0])));){
            String line;
            while ((line = in.readLine()) != null) {
                BookmarkData bookmarkData = BookmarkFileFactoryOld.getDataFromLine(line);
                dataList.add(bookmarkData);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(926362547, ex);
        }
    }

    private static BookmarkData getDataFromLine(String line) {
        String url = "";
        String theme = "";
        String title = "";
        String date = "";
        try {
            if (line.contains(SEPARATOR_2)) {
                int a1 = line.lastIndexOf(SEPARATOR_2);
                url = line.substring(a1 += SEPARATOR_2.length()).trim();
                title = line.substring(line.lastIndexOf(SEPARATOR_1) + SEPARATOR_1.length(), line.lastIndexOf(SEPARATOR_2)).trim();
                date = line.substring(0, line.indexOf(SEPARATOR_1)).trim();
                theme = line.substring(line.indexOf(SEPARATOR_1) + SEPARATOR_1.length(), line.lastIndexOf(SEPARATOR_1)).trim();
            } else {
                url = line;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(398853224, ex);
        }
        return new BookmarkData(date, theme, title, url);
    }
}

