/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.bookmark;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkData;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkList;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkLoadSaveFactory;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.tools.FileFactory;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.stage.Stage;

public class BookmarkFactory {
    private BookmarkFactory() {
    }

    public static void deleteAll(Stage stage) {
        int size = ProgData.getInstance().bookmarkList.size();
        if (size <= 1 || P2Alert.showAlertOkCancel(stage, "L\u00f6schen", "Bookmarks l\u00f6schen", "Soll die gesamte Liste (" + size + " Bookmarks) gel\u00f6scht werden?")) {
            ProgData.getInstance().bookmarkList.clearList();
            FileFactory.deleteHistoryFile("bookmarks.xml");
            ProgData.getInstance().filmList.forEach(film -> film.setBookmark(false));
            ProgData.getInstance().audioList.forEach(film -> film.setBookmark(false));
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BOOKMARK_CHANGED);
        }
    }

    public static void removeBookmark(BookmarkData bookmarkData) {
        if (bookmarkData.getFilmData() == null) {
            HashSet<String> hash = new HashSet<String>(1, 0.75f);
            hash.add(bookmarkData.getUrl());
            ProgData.getInstance().bookmarkList.removeUrlHash(hash);
        } else {
            BookmarkFactory.removeBookmark(bookmarkData.getFilmData());
        }
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BOOKMARK_CHANGED);
    }

    public static void removeBookmark(FilmDataMTP film) {
        ArrayList<FilmDataMTP> filmArrayList = new ArrayList<FilmDataMTP>(1);
        filmArrayList.add(film);
        BookmarkFactory.removeBookmarkList(filmArrayList);
    }

    public static void removeBookmarkList(ArrayList<FilmDataMTP> removeList) {
        if (removeList == null || removeList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("Bookmark: removeDataFromBookmark");
        HashSet<String> hash = new HashSet<String>(removeList.size() + 1, 0.75f);
        removeList.forEach(film -> {
            film.setBookmark(false);
            hash.add(film.getUrlHistory());
        });
        ProgData.getInstance().bookmarkList.removeUrlHash(hash);
        hash.clear();
        P2Duration.counterStop("Bookmark: removeDataFromBookmark");
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BOOKMARK_CHANGED);
    }

    public static int deleteFromDialog(Stage stage, boolean onlyCount) {
        if (onlyCount) {
            P2Log.sysLog("Bookmarks l\u00f6schen, onlyCount");
        } else {
            P2Log.sysLog("Bookmarks l\u00f6schen");
        }
        int count = 0;
        if (ProgConfig.BOOKMARK_DEL_ALL.get()) {
            count = ProgData.getInstance().bookmarkList.size();
            if (!onlyCount) {
                BookmarkFactory.deleteAll(stage);
            }
            return count;
        }
        ArrayList<BookmarkData> delList = new ArrayList<BookmarkData>();
        int delDays = ProgConfig.BOOKMARK_DEL_OLD_COUNT_DAYS.get();
        for (BookmarkData b : ProgData.getInstance().bookmarkList) {
            long days;
            long diff;
            LocalDate ld;
            if (ProgConfig.BOOKMARK_DEL_SHOWN.get() && b.getFilmData() != null && b.getFilmData().isShown()) {
                ++count;
                if (onlyCount) continue;
                delList.add(b);
                continue;
            }
            if (!ProgConfig.BOOKMARK_DEL_OLD.get() || (ld = b.getDate().getLocalDate()) == null || (diff = Math.abs(days = ChronoUnit.DAYS.between(ld, LocalDate.now()))) < (long)delDays) continue;
            ++count;
            if (onlyCount) continue;
            delList.add(b);
        }
        if (!onlyCount) {
            if (delList.isEmpty()) {
                P2Alert.showInfoAlert(stage, "L\u00f6schen", "Bookmarks l\u00f6schen", "Es sind keine Bookmarks zum L\u00f6schen, in der Liste.");
                return 0;
            }
            BookmarkFactory.deleteList(delList);
        }
        return count;
    }

    private static void deleteList(List<BookmarkData> list) {
        HashSet<String> hash = new HashSet<String>(list.size(), 0.75f);
        list.forEach(bookmarkData -> {
            if (bookmarkData.getFilmData() != null) {
                bookmarkData.getFilmData().setBookmark(false);
            }
            hash.add(bookmarkData.getUrl());
        });
        ProgData.getInstance().bookmarkList.removeUrlHash(hash);
        ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BOOKMARK_CHANGED);
    }

    public static void addBookmark(boolean audio, FilmDataMTP film) {
        ArrayList<FilmDataMTP> filmArrayList = new ArrayList<FilmDataMTP>(1);
        filmArrayList.add(film);
        BookmarkFactory.addBookmarkList(audio, filmArrayList);
    }

    public static void addBookmarkList(boolean audio, ArrayList<FilmDataMTP> filmArrayList) {
        if (filmArrayList == null || filmArrayList.isEmpty()) {
            return;
        }
        P2Duration.counterStart("addFilmDataToBookmark");
        for (FilmDataMTP film : filmArrayList) {
            if (film.isLive()) continue;
            film.setBookmark(true);
            if (ProgData.getInstance().bookmarkList.checkIfUrlAlreadyIn(film.getUrlHistory())) continue;
            BookmarkData bookmarkData = new BookmarkData(audio, film);
            ProgData.getInstance().bookmarkList.addToThisList(bookmarkData);
        }
        BookmarkLoadSaveFactory.saveBookmark();
        P2Duration.counterStop("addFilmDataToBookmark");
    }

    public static void markBookmarks() {
        if (ProgData.getInstance().bookmarkList.isEmpty()) {
            return;
        }
        BookmarkList bookmarkList = ProgData.getInstance().bookmarkList;
        HashMap hash = new HashMap();
        bookmarkList.forEach(b -> hash.put(b.getUrl(), b));
        P2Duration.counterStart("markBookmarks");
        ProgData.getInstance().filmList.forEach(film -> {
            BookmarkData bookmarkData = (BookmarkData)hash.get(film.getUrlHistory());
            if (bookmarkData != null) {
                film.setBookmark(true);
                bookmarkData.setFilmData((FilmDataMTP)film);
            }
        });
        ProgData.getInstance().audioList.forEach(film -> {
            BookmarkData bookmarkData = (BookmarkData)hash.get(film.getUrlHistory());
            if (bookmarkData != null) {
                film.setBookmark(true);
                bookmarkData.setFilmData((FilmDataMTP)film);
            }
        });
        P2Duration.counterStop("markBookmarks");
    }
}

