/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.bookmark;

import de.p2tools.mtplayer.controller.data.bookmark.BookmarkDataProps;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.p2lib.mediathek.film.FilmDate;
import org.apache.commons.lang3.time.FastDateFormat;

public class BookmarkData
extends BookmarkDataProps {
    private static final FastDateFormat sdf_datum = FastDateFormat.getInstance("dd.MM.yyyy");
    private FilmDataMTP filmData = null;

    public BookmarkData() {
    }

    public BookmarkData(boolean audio, FilmDataMTP filmDataMTP) {
        this.setAudio(audio);
        this.setChannel(filmDataMTP.getChannel());
        this.setTheme(filmDataMTP.getTheme());
        this.setTitle(filmDataMTP.getTitle());
        this.setUrl(filmDataMTP.getUrlHistory());
        this.setDate(new FilmDate());
        this.filmData = filmDataMTP;
    }

    public BookmarkData(String date, String theme, String title, String url) {
        this.setTitle(title);
        this.setTheme(theme);
        this.setUrl(url);
        try {
            FilmDate d = new FilmDate(sdf_datum.parse(date).getTime());
            this.setDate(d);
        }
        catch (Exception ignore) {
            this.setDate(new FilmDate(0L));
        }
    }

    public FilmDataMTP getFilmData() {
        return this.filmData;
    }

    public void setFilmData(FilmDataMTP filmData) {
        this.filmData = filmData;
    }
}

