/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.blackdata;

import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.film.FilmListMTP;
import de.p2tools.mtplayer.controller.filter.FilterWorker;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.FilmDataProps;
import de.p2tools.p2lib.mediathek.filter.FilmFilterCheck;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.List;
import java.util.stream.Stream;

public class BlacklistFilterFactory {
    public static final int BLACKLILST_FILTER_OFF = 0;
    public static final int BLACKLILST_FILTER_ON = 1;
    public static final int BLACKLILST_FILTER_INVERS = 2;
    private static long maxFilmDays = 0L;
    private static boolean doNotShowFutureFilms;
    private static boolean doNotShowGeoBlockedFilms;
    private static boolean doNotShowDoubleFilms;
    private static long minFilmDuration;
    private static int act;
    private static int now;

    private BlacklistFilterFactory() {
    }

    public static synchronized void markFilmsIfBlack(boolean notify) {
        ProgData.getInstance().blackList.clearCounter();
        BlacklistFilterFactory.markFilmsIfBlack(true, notify);
        BlacklistFilterFactory.markFilmsIfBlack(false, notify);
    }

    public static synchronized void markFilmsIfBlack(boolean audio, boolean notify) {
        boolean maskerPane;
        P2Duration.counterStart("markFilmBlack" + (audio ? "-Audio" : "-Film"));
        P2Log.sysLog("markFilmBlack " + (audio ? "Audio" : "Film") + " -> start");
        if (ProgData.getInstance().maskerPane.isVisible()) {
            maskerPane = true;
            ProgData.getInstance().maskerPane.setMaskerText("Blacklist filtern");
        } else {
            maskerPane = false;
        }
        BlacklistFilterFactory.loadCurrentBlacklistSettings();
        P2Duration.counterStart("forEach");
        FilmListMTP list = audio ? ProgData.getInstance().audioList : ProgData.getInstance().filmList;
        int sum = list.size();
        act = 0;
        now = 0;
        list.forEach(film -> {
            ++act;
            if (++now > 5000) {
                now = 0;
                double percent = (double)act / (double)sum;
                ProgData.busy.setProgress(percent);
                if (maskerPane) {
                    ProgData.getInstance().maskerPane.setMaskerProgress(percent, "Blacklist filtern");
                }
            }
            film.setBlackBlocked(BlacklistFilterFactory.checkFilmIsBlackComplete(audio, film, ProgData.getInstance().blackList, true));
        });
        P2Duration.counterStop("forEach");
        BlacklistFilterFactory.makeBlackFilteredFilmlist(audio);
        if (maskerPane) {
            ProgData.getInstance().maskerPane.setMaskerProgress(-1.0, "Blacklist filtern");
        }
        P2Log.sysLog("markFilmBlack " + (audio ? "Audio" : "Film") + " stop");
        P2Duration.counterStop("markFilmBlack" + (audio ? "-Audio" : "-Film"));
        if (notify) {
            ProgData.getInstance().pEventHandler.notifyListener(PEvents.EVENT_BLACKLIST_CHANGED);
        }
    }

    public static synchronized void makeBlackFilteredFilmlist(boolean audio) {
        FilmListMTP filmListFiltered;
        FilmListMTP filmList;
        FilterWorker filterWorker;
        ProgData progData = ProgData.getInstance();
        FilterWorker filterWorker2 = filterWorker = audio ? progData.filterWorkerAudio : progData.filterWorkerFilm;
        if (audio) {
            filmList = progData.audioList;
            filmListFiltered = progData.audioListFiltered;
        } else {
            filmList = progData.filmList;
            filmListFiltered = progData.filmListFiltered;
        }
        P2Duration.counterStart("makeBlackFilteredFilmlist");
        filmListFiltered.clear();
        if (filmList != null) {
            filmListFiltered.setMeta(filmList);
            Stream<Object> initialStream = filmList.parallelStream();
            if (filterWorker.getActFilterSettings().getBlacklistOnOff() == 2) {
                P2Log.sysLog("FilmlistBlackFilter - isBlacklistOnly");
                initialStream = initialStream.filter(FilmDataProps::isBlackBlocked);
            } else if (filterWorker.getActFilterSettings().getBlacklistOnOff() == 1) {
                P2Log.sysLog("FilmlistBlackFilter - isBlacklistOn");
                initialStream = initialStream.filter(filmDataMTP -> !filmDataMTP.isBlackBlocked());
            } else {
                P2Log.sysLog("FilmlistBlackFilter - isBlacklistOff");
            }
            filmListFiltered.addAll(initialStream.toList());
            filmListFiltered.loadTheme();
        }
        P2Duration.counterStop("makeBlackFilteredFilmlist");
    }

    public static synchronized boolean checkFilmIsBlackComplete(boolean audio, FilmData filmData, List<BlackData> list, boolean incCounter) {
        if (doNotShowGeoBlockedFilms && filmData.isGeoBlocked()) {
            return true;
        }
        if (doNotShowDoubleFilms && filmData.isDoubleUrl()) {
            return true;
        }
        if (doNotShowFutureFilms && filmData.isInFuture()) {
            return true;
        }
        if (minFilmDuration != 0L && !BlacklistFilterFactory.checkFilmLength(filmData)) {
            return true;
        }
        if (maxFilmDays > 0L && !BlacklistFilterFactory.checkDate(filmData)) {
            return true;
        }
        return BlacklistFilterFactory.checkFilmIsBlack(audio, filmData, list, incCounter);
    }

    private static boolean checkFilmLength(FilmData film) {
        return film.getDurationMinute() == 0 || (long)film.getDurationMinute() >= minFilmDuration;
    }

    private static boolean checkDate(FilmData film) {
        long filmTime = film.filmDate.getTime();
        return filmTime == 0L || filmTime > maxFilmDays;
    }

    public static boolean checkFilmIsBlack(boolean audio, FilmData filmData, List<BlackData> list, boolean countHits) {
        filmData.setLowerCase();
        for (BlackData blackData : list) {
            if (!blackData.isActive() || audio && blackData.getList() == 1 || !audio && blackData.getList() == 2 || !BlacklistFilterFactory.checkFilmIsBlocked(blackData, filmData)) continue;
            if (countHits) {
                blackData.incCountHits();
            }
            filmData.clearLowerCase();
            return true;
        }
        filmData.clearLowerCase();
        return false;
    }

    private static void loadCurrentBlacklistSettings() {
        try {
            if (ProgConfig.SYSTEM_BLACKLIST_MAX_FILM_DAYS.getValue() == 0) {
                maxFilmDays = 0L;
            } else {
                long max = 86400000L * (long)ProgConfig.SYSTEM_BLACKLIST_MAX_FILM_DAYS.getValue().intValue();
                maxFilmDays = System.currentTimeMillis() - max;
            }
        }
        catch (Exception ex) {
            maxFilmDays = 0L;
        }
        minFilmDuration = ProgConfig.SYSTEM_BLACKLIST_MIN_FILM_DURATION.getValue().intValue();
        doNotShowFutureFilms = ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_FUTURE.getValue();
        doNotShowGeoBlockedFilms = ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_GEO.getValue();
        doNotShowDoubleFilms = ProgConfig.SYSTEM_BLACKLIST_SHOW_NO_DOUBLE.getValue();
    }

    public static boolean checkFilmIsBlocked(BlackData blackData, FilmData filmData) {
        if (blackData.quickChannel) {
            return filmData.FILM_CHANNEL_STR.contains(blackData.fChannel.filterArr[0]);
        }
        if (blackData.quickTheme) {
            if (blackData.fTheme.isExact) {
                return filmData.FILM_THEME_STR.equals(blackData.fTheme.filterArr[0]);
            }
            if (filmData.FILM_THEME_STR.contains(blackData.fTheme.filterArr[0])) {
                return !blackData.fTheme.exclude;
            }
            return blackData.fTheme.exclude;
        }
        if (blackData.quickThemTitle) {
            if (filmData.FILM_THEME_STR.contains(blackData.fThemeTitle.filterArr[0]) || filmData.FILM_TITLE_STR.contains(blackData.fThemeTitle.filterArr[0])) {
                return !blackData.fThemeTitle.exclude;
            }
            return blackData.fThemeTitle.exclude;
        }
        if (blackData.quickTitle) {
            if (filmData.FILM_TITLE_STR.contains(blackData.fTitle.filterArr[0])) {
                return !blackData.fTitle.exclude;
            }
            return blackData.fTitle.exclude;
        }
        boolean ret = FilmFilterCheck.checkFilterMatch(blackData.fChannel, blackData.fTheme, blackData.fThemeTitle, blackData.fTitle, filmData);
        return ret;
    }

    static {
        minFilmDuration = 0L;
        act = 0;
        now = 0;
    }
}

