/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.blackdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackList;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.gui.dialog.AddBlackListDialogController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BlacklistFactory {
    private BlacklistFactory() {
    }

    public static List<BlackData> getSubList(boolean audio, List<BlackData> list) {
        ArrayList<BlackData> ret = new ArrayList<BlackData>();
        list.stream().filter(b -> b.getList() == 0 || audio && b.getList() == 2 || !audio && b.getList() == 1).forEach(ret::add);
        return ret;
    }

    public static boolean blackExistsAlready(BlackData blackData, List<BlackData> list) {
        for (BlackData data : list) {
            if (!data.getChannel().equalsIgnoreCase(blackData.getChannel()) || !data.getTheme().equalsIgnoreCase(blackData.getTheme()) || (!data.getTheme().isEmpty() || !blackData.getTheme().isEmpty()) && data.isThemeExact() != blackData.isThemeExact() || !data.getTitle().equalsIgnoreCase(blackData.getTitle()) || !data.getThemeTitle().equalsIgnoreCase(blackData.getThemeTitle())) continue;
            return true;
        }
        return false;
    }

    public static void addBlackFilm(BLACK_SRC blackSRC) {
        BlackData blackData = null;
        if (blackSRC.equals((Object)BLACK_SRC.FILM)) {
            filmDataMTP = ProgData.getInstance().filmGuiController.getSel(true, true);
            if (filmDataMTP.isEmpty()) {
                return;
            }
            blackData = new BlackData(1, filmDataMTP.get().getChannel(), filmDataMTP.get().getTheme(), filmDataMTP.get().getTitle(), "");
        } else if (blackSRC.equals((Object)BLACK_SRC.AUDIO)) {
            filmDataMTP = ProgData.getInstance().audioGuiController.getSel(true, true);
            if (filmDataMTP.isEmpty()) {
                return;
            }
            blackData = new BlackData(2, filmDataMTP.get().getChannel(), filmDataMTP.get().getTheme(), filmDataMTP.get().getTitle(), "");
        } else if (blackSRC.equals((Object)BLACK_SRC.DOWNLOAD)) {
            Optional<DownloadData> downloadData = ProgData.getInstance().downloadGuiController.getSel(true);
            if (downloadData.isEmpty()) {
                return;
            }
            blackData = new BlackData(0, downloadData.get().getChannel(), downloadData.get().getTheme(), downloadData.get().getTitle(), "");
        }
        AddBlackListDialogController addBlacklistDialogController = new AddBlackListDialogController(blackData);
        if (!addBlacklistDialogController.isOk()) {
            return;
        }
        ProgData.getInstance().blackList.add(blackData);
        new Thread(() -> BlacklistFilterFactory.markFilmsIfBlack(true)).start();
    }

    public static void addBlackThemeFilm(BLACK_SRC blackSRC) {
        if (blackSRC.equals((Object)BLACK_SRC.FILM)) {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().filmGuiController.getSel(true, true);
            if (filmSelection.isEmpty()) {
                return;
            }
            BlacklistFactory.addBlack(1, "", filmSelection.get().getTheme(), "");
        } else if (blackSRC.equals((Object)BLACK_SRC.AUDIO)) {
            Optional<FilmDataMTP> filmSelection = ProgData.getInstance().audioGuiController.getSel(true, true);
            if (filmSelection.isEmpty()) {
                return;
            }
            BlacklistFactory.addBlack(2, "", filmSelection.get().getTheme(), "");
        }
    }

    public static void addBlackTitleDownload() {
        Optional<DownloadData> downloadData = ProgData.getInstance().downloadGuiController.getSel(true);
        if (downloadData.isEmpty()) {
            return;
        }
        BlacklistFactory.addBlack(0, "", "", downloadData.get().getTitle());
    }

    public static void addBlackSenderThemeDownload() {
        Optional<DownloadData> downloadData = ProgData.getInstance().downloadGuiController.getSel(true);
        if (downloadData.isEmpty()) {
            return;
        }
        BlacklistFactory.addBlack(0, downloadData.get().getChannel(), downloadData.get().getTheme(), "");
    }

    public static void addBlackThemeDownload() {
        Optional<DownloadData> downloadData = ProgData.getInstance().downloadGuiController.getSel(true);
        if (downloadData.isEmpty()) {
            return;
        }
        BlacklistFactory.addBlack(0, "", downloadData.get().getTheme(), "");
    }

    public static void addBlack(int list, String sender, String theme, String titel) {
        BlackData blackData = new BlackData(list, sender, theme, titel, "");
        ProgData.getInstance().blackList.add(blackData);
        new Thread(() -> BlacklistFilterFactory.markFilmsIfBlack(true)).start();
    }

    public static boolean blackIsEmpty(BlackData blackData) {
        return blackData.getChannel().isEmpty() && blackData.getTheme().isEmpty() && blackData.getTitle().isEmpty() && blackData.getThemeTitle().isEmpty();
    }

    public static void addStandardsList(BlackList list) {
        BlackData bl = new BlackData(1, "", "", "- Audiodeskription", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "(Audiodeskription)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "(Geb\u00e4rdensprache)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "mit Geb\u00e4rdensprache", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "(mit Untertitel)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "(Originalversion mit Untertitel)", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "in Geb\u00e4rdensprache", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "in Geb\u00e4rdensprache", "", "");
        bl.setThemeExact(false);
        list.add(bl);
        bl = new BlackData(1, "", "", "\"Trailer:\"", "");
        bl.setThemeExact(false);
        list.add(bl);
        new Thread(() -> BlacklistFilterFactory.markFilmsIfBlack(true)).start();
    }

    public static enum BLACK_SRC {
        FILM,
        AUDIO,
        DOWNLOAD;

    }
}

