/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.blackdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.List;

public class BlacklistCountFactory {
    private static int act = 0;
    private static int now = 0;

    private BlacklistCountFactory() {
    }

    public static synchronized void countHits(List<BlackData> list) {
        P2Duration.counterStart("countHits");
        for (BlackData bl : list) {
            bl.clearCounter();
        }
        int sum = ProgData.getInstance().audioList.size() + ProgData.getInstance().filmList.size();
        act = 0;
        now = 0;
        List<BlackData> copyListFilm = BlacklistFactory.getSubList(false, list);
        ProgData.getInstance().filmList.forEach(film -> {
            ++act;
            if (++now > 1000) {
                now = 0;
                double percent = (double)act / (double)sum;
                ProgData.busy.setProgress(percent);
            }
            BlacklistCountFactory.countHitsFilmlist(film, copyListFilm);
        });
        List<BlackData> copyListAudio = BlacklistFactory.getSubList(true, list);
        ProgData.getInstance().audioList.forEach(film -> {
            ++act;
            if (++now > 1000) {
                now = 0;
                double percent = (double)act / (double)sum;
                ProgData.busy.setProgress(percent);
            }
            BlacklistCountFactory.countHitsFilmlist(film, copyListAudio);
        });
        P2Duration.counterStop("countHits");
    }

    private static void countHitsFilmlist(FilmData filmData, List<BlackData> list) {
        filmData.setLowerCase();
        list.parallelStream().forEach(blackData -> {
            if (BlacklistFilterFactory.checkFilmIsBlocked(blackData, filmData)) {
                blackData.incCountHits();
            }
        });
        filmData.clearLowerCase();
    }
}

