/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.blackdata;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackData;
import de.p2tools.mtplayer.controller.data.blackdata.BlackDataProps;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class BlackList
extends SimpleListProperty<BlackData>
implements P2DataList<BlackData> {
    public String TAG = "BlackList";
    private int no = 1;
    private final ProgData progData;
    private FilteredList<BlackData> filteredList = null;
    private SortedList<BlackData> sortedList = null;
    private final ObservableList<BlackData> undoList = FXCollections.observableArrayList();

    public BlackList(ProgData progData, String tag) {
        super(FXCollections.observableArrayList());
        this.progData = progData;
        this.TAG = tag;
    }

    public SortedList<BlackData> getSortedList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<BlackData>(this, p -> true);
            this.sortedList = new SortedList<BlackData>((ObservableList<BlackData>)this.filteredList);
        }
        return this.sortedList;
    }

    public FilteredList<BlackData> getFilteredList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<BlackData>(this, p -> true);
            this.sortedList = new SortedList<BlackData>((ObservableList<BlackData>)this.filteredList);
        }
        return this.filteredList;
    }

    public synchronized void filteredListSetPred(Predicate<BlackData> predicate) {
        P2Duration.counterStart("filteredListSetPred");
        this.getFilteredList().setPredicate(predicate);
        P2Duration.counterStop("filteredListSetPred");
    }

    @Override
    public String getTag() {
        return this.TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller BlackData";
    }

    @Override
    public BlackData getNewItem() {
        return new BlackData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(BlackData.class)) {
            this.add((BlackData)obj);
        }
    }

    @Override
    public synchronized boolean add(BlackData b) {
        b.setNo(this.no++);
        return super.add(b);
    }

    public synchronized void removeBlackData(List<BlackData> list) {
        this.addBlackDataToUndoList(list);
        this.removeAll((Collection<?>)list);
    }

    public synchronized void clearList() {
        this.addBlackDataToUndoList(this);
        super.clear();
    }

    public synchronized void clearCounter() {
        for (BlackData blackData : this) {
            blackData.clearCounter();
        }
    }

    public synchronized void sortAndCleanTheList() {
        this.sort(Comparator.comparingInt(BlackDataProps::getCountHits).reversed());
        this.cleanTheList();
    }

    public synchronized void cleanTheList() {
        ArrayList blackList = new ArrayList();
        this.forEach(bl -> {
            if (!BlacklistFactory.blackIsEmpty(bl) && !BlacklistFactory.blackExistsAlready(bl, blackList)) {
                blackList.add(bl);
            }
        });
        this.setAll(blackList);
        this.no = 1;
        for (BlackData blackData : this) {
            blackData.setNo(this.no++);
        }
    }

    public ObservableList<BlackData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addBlackDataToUndoList(List<BlackData> list) {
        this.undoList.setAll((Collection<BlackData>)list);
    }

    public synchronized void undoBlackData() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.addAll(this.undoList);
        this.undoList.clear();
    }
}

