/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.abo;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgConst;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboDataProps;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFilterFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import de.p2tools.mtplayer.controller.data.download.DownloadFactory;
import de.p2tools.mtplayer.controller.data.download.DownloadList;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.film.FilmListMTP;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.mtplayer.gui.dialog.NoSetDialogController;
import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.concurrent.Task;

public class AboSearchDownloadsFactory {
    private static boolean found = false;
    public static BooleanProperty alreadyRunning = new SimpleBooleanProperty(false);
    private static int act = 0;
    private static int now = 0;
    private static int count = 0;

    private AboSearchDownloadsFactory() {
    }

    public static void searchFromDialog(boolean fromOk) {
        if (ProgConfig.ABO_SEARCH_NOW.getValue().booleanValue()) {
            alreadyRunning.set(true);
            ProgData.busy.busyOn(fromOk ? Busy.BUSY_SRC.GUI : Busy.BUSY_SRC.ABO_DIALOG, "Downloads suchen:", -1.0, false);
        }
        ProgData.getInstance().aboList.notifyChanges();
    }

    public static void searchForDownloadsFromAbosAndMaybeStart() {
        alreadyRunning.set(true);
        ProgData.busy.busyOnFx(Busy.BUSY_SRC.GUI, "Downloads suchen:", -1.0, false);
        if (ProgData.FILMLIST_IS_DOWNLOADING.get() || ProgData.AUDIOLIST_IS_DOWNLOADING.get()) {
            ProgData.busy.busyOffFx();
            alreadyRunning.set(false);
            return;
        }
        if (ProgData.getInstance().setDataList.getSetDataForAbo("") == null) {
            Platform.runLater(() -> new NoSetDialogController(ProgData.getInstance(), NoSetDialogController.TEXT.ABO));
            ProgData.busy.busyOffFx();
            alreadyRunning.set(false);
            return;
        }
        P2Log.sysLog("Downloads aus Abos suchen");
        count = ProgData.getInstance().downloadList.getSize();
        DownloadFactory.refreshDownloads(ProgData.getInstance().downloadList);
        new Thread(new Task<Void>(){

            @Override
            protected Void call() {
                AboSearchDownloadsFactory.searchForNewDownloadsForAbos(ProgData.getInstance().downloadList);
                ProgData.getInstance().downloadList.setDownloadsChanged();
                ProgData.busy.busyOffFx();
                alreadyRunning.set(false);
                return null;
            }
        }).start();
    }

    private static void searchForNewDownloadsForAbos(DownloadList downloadList) {
        P2Duration.counterStart("searchForNewDownloadsForAbos");
        List<DownloadData> syncDownloadArrayList = Collections.synchronizedList(new ArrayList());
        ProgData.getInstance().aboList.forEach(AboDataProps::clearCountHit);
        Set<String> syncDownloadsAlreadyInTheListHash = Collections.synchronizedSet(new HashSet(500));
        downloadList.forEach(download -> syncDownloadsAlreadyInTheListHash.add(download.getUrl()));
        int sum = ProgData.getInstance().audioList.size() + ProgData.getInstance().filmList.size();
        act = 0;
        now = 0;
        AboSearchDownloadsFactory.search(false, sum, syncDownloadArrayList, syncDownloadsAlreadyInTheListHash);
        AboSearchDownloadsFactory.search(true, sum, syncDownloadArrayList, syncDownloadsAlreadyInTheListHash);
        if (found) {
            Platform.runLater(() -> {
                AboSearchDownloadsFactory.searchDownloadsAfter(syncDownloadArrayList, downloadList, syncDownloadsAlreadyInTheListHash);
                ProgData.downloadSearchDone = true;
                P2Duration.counterStop("searchForNewDownloadsForAbos");
            });
        } else {
            ProgData.downloadSearchDone = true;
            P2Duration.counterStop("searchForNewDownloadsForAbos");
        }
    }

    private static void search(boolean audio, int sum, List<DownloadData> syncDownloadArrayList, Set<String> syncDownloadsAlreadyInTheListHash) {
        boolean checkWithBlackList = ProgConfig.SYSTEM_BLACKLIST_SHOW_ABO.getValue();
        FilmListMTP filmList = audio ? ProgData.getInstance().audioList : ProgData.getInstance().filmList;
        filmList.parallelStream().forEach(film -> {
            AboData aboData;
            ++act;
            if (++now > 5000) {
                now = 0;
                double percent = (double)act / (double)sum;
                ProgData.busy.setProgress(percent);
            }
            if ((aboData = film.getAbo()) == null) {
                return;
            }
            aboData.incrementCountHit();
            if (checkWithBlackList && BlacklistFilterFactory.checkFilmIsBlackComplete(audio, film, ProgData.getInstance().blackList, false)) {
                return;
            }
            if (ProgData.getInstance().historyListAbos.checkIfUrlAlreadyIn(film.getUrlHistory())) {
                return;
            }
            String urlDownload = film.getUrlForResolution(aboData.getResolution());
            if (!syncDownloadsAlreadyInTheListHash.add(urlDownload)) {
                return;
            }
            aboData.setDate(new P2Date());
            SetData setData = AboFactory.getSetData(ProgData.getInstance(), aboData);
            DownloadData downloadData = syncDownloadArrayList.size() < ProgConst.DOWNLOAD_ADD_DIALOG_MAX_LOOK_FILE_SIZE ? new DownloadData(audio, "Abo", setData, (FilmDataMTP)film, aboData, "", "", true) : new DownloadData(audio, "Abo", setData, (FilmDataMTP)film, aboData, "", "", false);
            syncDownloadArrayList.add(downloadData);
            found = true;
        });
    }

    private static void searchDownloadsAfter(List<DownloadData> syncDownloadArrayList, DownloadList downloadList, Set<String> syncDownloadsAlreadyInTheListHash) {
        AboSearchDownloadsFactory.checkDoubleNames(syncDownloadArrayList, downloadList);
        downloadList.addAll(syncDownloadArrayList);
        downloadList.setNumbersInList();
        syncDownloadArrayList.clear();
        syncDownloadsAlreadyInTheListHash.clear();
        ProgData.getInstance().aboList.forEach(AboDataProps::setCountedHits);
        if (ProgData.getInstance().downloadList.getSize() == count) {
            ProgData.getInstance().downloadList.setDownloadsChanged();
        }
        if (ProgConfig.DOWNLOAD_START_NOW.getValue().booleanValue() || ProgData.autoMode) {
            P2Log.sysLog("Downloads aus Abos starten");
            ProgData.getInstance().downloadList.startAllDownloads();
        }
    }

    private static void checkDoubleNames(List<DownloadData> foundNewDownloads, List<DownloadData> downloadList) {
        try {
            Set<String> fileNames = Collections.synchronizedSet(new HashSet(foundNewDownloads.size() + downloadList.size()));
            downloadList.forEach(download -> fileNames.add(download.getDestPathFile()));
            for (DownloadData foundDownload : foundNewDownloads) {
                if (fileNames.contains(foundDownload.getDestPathFile())) {
                    int i = 1;
                    String newName = AboSearchDownloadsFactory.getNextFileName(foundDownload.getDestPathFile(), i);
                    while (fileNames.contains(newName)) {
                        newName = AboSearchDownloadsFactory.getNextFileName(foundDownload.getDestPathFile(), ++i);
                    }
                    foundDownload.setFile(newName);
                }
                fileNames.add(foundDownload.getDestPathFile());
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(303021458, ex);
        }
    }

    private static void checkDoubleNames_old(List<DownloadData> foundNewDownloads, List<DownloadData> downloadList) {
        try {
            ArrayList alreadyDone = new ArrayList();
            foundNewDownloads.forEach(download -> {
                String oldName;
                String newName = oldName = download.getDestPathFile();
                int i = 0;
                while (AboSearchDownloadsFactory.searchName(downloadList, newName) || AboSearchDownloadsFactory.searchName(alreadyDone, newName)) {
                    newName = AboSearchDownloadsFactory.getNextFileName(oldName, ++i);
                }
                if (!oldName.equals(newName)) {
                    download.setFile(newName);
                }
                alreadyDone.add(download);
            });
        }
        catch (Exception ex) {
            P2Log.errorLog(303021458, ex);
        }
    }

    private static String getNextFileName(String file, int i) {
        String suffix = P2FileUtils.getFileNameSuffix(file);
        String name = P2FileUtils.getFileNameWithOutExtension(file);
        String path = P2FileUtils.getPath(file);
        return Paths.get(path, name + "_" + i + "." + suffix).toString();
    }

    private static boolean searchName(List<DownloadData> searchDownloadList, String name) {
        return searchDownloadList.stream().anyMatch(download -> download.getDestPathFile().equals(name));
    }
}

