/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.abo;

import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.replace.ReplaceFactory;
import de.p2tools.mtplayer.controller.filter.FilmFilter;
import de.p2tools.mtplayer.gui.dialog.AboDelDialogController;
import de.p2tools.mtplayer.gui.dialog.abodialog.AboAddDialogController;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.mediathek.filter.Filter;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class AboListFactory {
    private AboListFactory() {
    }

    public static void addNewAbo(int audio, String aboName, String filmChannel, String filmTheme, String filmTitle) {
        int maxDuration;
        int minDuration;
        try {
            minDuration = ProgConfig.ABO_MINUTE_MIN_SIZE.getValue();
            maxDuration = ProgConfig.ABO_MINUTE_MAX_SIZE.getValue();
        }
        catch (Exception ex) {
            minDuration = 0;
            maxDuration = 150;
            ProgConfig.ABO_MINUTE_MIN_SIZE.setValue(0);
            ProgConfig.ABO_MINUTE_MAX_SIZE.setValue(150);
        }
        String namePath = ReplaceFactory.replaceFileNameWithReplaceList(aboName, false);
        AboData abo = new AboData(ProgData.getInstance(), audio, namePath, filmChannel, filmTheme, false, "", filmTitle, "", 0, minDuration, maxDuration, namePath);
        new AboAddDialogController(ProgData.getInstance(), abo);
    }

    public static void addNewAboFromFilterButton(boolean audio) {
        Object searchChannel;
        FilmFilter filmFilter = audio ? ProgData.getInstance().filterWorkerAudio.getActFilterSettings() : ProgData.getInstance().filterWorkerFilm.getActFilterSettings();
        String channel = filmFilter.isChannelVis() ? filmFilter.getChannel() : "";
        boolean themeIsExact = filmFilter.isThemeIsExact();
        String theme = filmFilter.isThemeVis() ? filmFilter.getResTheme().trim() : "";
        String title = filmFilter.isTitleVis() ? filmFilter.getTitle().trim() : "";
        String themeTitle = filmFilter.isThemeTitleVis() ? filmFilter.getThemeTitle().trim() : "";
        String somewhere = filmFilter.isSomewhereVis() ? filmFilter.getSomewhere().trim() : "";
        int minDuration = filmFilter.isMinMaxDurVis() ? filmFilter.getMinDur() : 0;
        int maxDuration = filmFilter.isMinMaxDurVis() ? filmFilter.getMaxDur() : 150;
        Object searchTitle = "";
        Object object = searchChannel = channel.isEmpty() ? "" : channel + " - ";
        if (!themeTitle.isEmpty()) {
            searchTitle = (String)searchChannel + themeTitle;
        } else if (!theme.isEmpty() && !title.isEmpty()) {
            searchTitle = (String)searchChannel + theme + "-" + title;
        } else if (!theme.isEmpty() || !title.isEmpty()) {
            searchTitle = (String)searchChannel + theme + title;
        } else if (!somewhere.isEmpty()) {
            searchTitle = (String)searchChannel + somewhere;
        }
        if (((String)searchTitle).startsWith(Filter.FILTER_REG_EX)) {
            searchTitle = ((String)searchTitle).replaceFirst(Filter.FILTER_REG_EX, "");
        } else if (((String)searchTitle).startsWith(Filter.FILTER_EXCLUDE)) {
            searchTitle = ((String)searchTitle).replaceFirst(Filter.FILTER_EXCLUDE, "");
        }
        if (((String)searchTitle).isEmpty()) {
            searchTitle = "Abo aus Filter";
        }
        searchTitle = ReplaceFactory.replaceFileNameWithReplaceList((String)searchTitle, false);
        AboData abo = new AboData(ProgData.getInstance(), audio ? 2 : 1, (String)searchTitle, channel, theme, themeIsExact, themeTitle, title, somewhere, filmFilter.getTimeRange(), minDuration, maxDuration, (String)searchTitle);
        new AboAddDialogController(ProgData.getInstance(), abo);
    }

    public static void changeAboFromFilterButton() {
        Optional<AboData> oAbo = ProgData.getInstance().aboGuiController.getSel();
        if (oAbo.isEmpty()) {
            return;
        }
        AboData abo = oAbo.get();
        new AboAddDialogController(ProgData.getInstance(), ProgData.getInstance().filterWorkerFilm.getActFilterSettings(), abo);
    }

    public static void setFilmFilterFromAbo() {
        Optional<AboData> abo = ProgData.getInstance().aboGuiController.getSel();
        ProgData.getInstance().filterWorkerFilm.setFilterFromAbo(abo);
    }

    public static void editAbo() {
        ObservableList<AboData> aboList = ProgData.getInstance().aboGuiController.getSelList();
        if (!aboList.isEmpty()) {
            new AboAddDialogController(ProgData.getInstance(), aboList);
        }
    }

    public static void editAbo(AboData abo) {
        if (abo != null) {
            new AboAddDialogController(ProgData.getInstance(), FXCollections.observableArrayList(abo));
        }
    }

    public static void setAboActive(boolean on) {
        ObservableList<AboData> lAbo = ProgData.getInstance().aboGuiController.getSelList();
        ProgData.getInstance().aboList.setAboActive(lAbo, on);
    }

    public static void setAboActive(AboData abo, boolean on) {
        ProgData.getInstance().aboList.setAboActive(abo, on);
    }

    public static void deleteAbo() {
        AboListFactory.deleteAbo(ProgData.getInstance().aboGuiController.getSelList());
    }

    public static void deleteAbo(AboData abo) {
        if (abo == null) {
            return;
        }
        AboListFactory.deleteAbo(FXCollections.observableArrayList(abo));
    }

    private static void deleteAbo(ObservableList<AboData> lAbo) {
        AboDelDialogController aboDelDialog;
        if (lAbo.isEmpty()) {
            return;
        }
        if (ProgConfig.ABO_ONLY_STOP.getValue() == 0 && (aboDelDialog = new AboDelDialogController(lAbo)).getState() != P2DialogExtra.STATE.STATE_OK) {
            P2Log.sysLog("Abo l\u00f6schen: Abbruch");
            return;
        }
        ProgData.getInstance().aboList.deleteAbo(lAbo);
    }
}

