/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.abo;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboFactory;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.GermanStringSorter;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class AboList
extends SimpleListProperty<AboData>
implements P2DataList<AboData> {
    private final ProgData progData;
    public static final String TAG = "AboList";
    private int no;
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private final BooleanProperty listChanged = new SimpleBooleanProperty(true);
    private final ObservableList<AboData> undoList = FXCollections.observableArrayList();

    public AboList(ProgData progData) {
        super(FXCollections.observableArrayList());
        this.progData = progData;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Abos";
    }

    @Override
    public AboData getNewItem() {
        return new AboData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(AboData.class)) {
            this.add((AboData)obj);
        }
    }

    public BooleanProperty listChangedProperty() {
        return this.listChanged;
    }

    public synchronized void initAboList() {
        this.forEach(abo -> abo.initAbo(this.progData, ++this.no));
    }

    public synchronized void sortAlphabetically() {
        this.sort(Comparator.comparing(o -> o.getName().toLowerCase(Locale.ROOT)));
    }

    public synchronized void addAbo(AboData abo) {
        ++this.no;
        abo.setNo(this.no);
        if (abo.getName().isEmpty()) {
            abo.setName("Abo_" + this.no);
        }
        if (abo.getResolution().isEmpty()) {
            abo.setResolution("normal");
        }
        super.add(abo);
    }

    public synchronized void setAboActive(List<AboData> lAbo, boolean on) {
        if (!lAbo.isEmpty()) {
            lAbo.forEach(abo -> abo.setActive(on));
            this.notifyChanges();
        }
    }

    public synchronized void setAboActive(AboData abo, boolean on) {
        abo.setActive(on);
        this.notifyChanges();
    }

    public synchronized void deleteAbo(ObservableList<AboData> lAbo) {
        P2Log.sysLog("Abo l\u00f6schen");
        this.addAbosToUndoList(lAbo);
        this.removeAll((Collection<?>)lAbo);
        this.notifyChanges();
    }

    public synchronized void notifyChanges() {
        if (!ProgData.FILMLIST_IS_DOWNLOADING.get() && !ProgData.AUDIOLIST_IS_DOWNLOADING.get()) {
            AboFactory.setAboForList();
        }
        this.listChanged.setValue(!this.listChanged.get());
    }

    public synchronized ArrayList<String> getAboSubDirList() {
        ArrayList<String> path = new ArrayList<String>();
        for (AboData abo : this) {
            String s = abo.getAboSubDir();
            if (path.contains(s)) continue;
            path.add(abo.getAboSubDir());
        }
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        path.sort(sorter);
        return path;
    }

    public synchronized ArrayList<String> getAboDirList() {
        ArrayList<String> path = new ArrayList<String>();
        for (AboData abo : this) {
            String s = abo.getAboDir();
            if (path.contains(s)) continue;
            path.add(abo.getAboDir());
        }
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        path.sort(sorter);
        return path;
    }

    public synchronized ArrayList<String> getAboFileNameList() {
        ArrayList<String> fileName = new ArrayList<String>();
        for (AboData abo : this) {
            String s = abo.getAboFileName();
            if (fileName.contains(s)) continue;
            fileName.add(abo.getAboFileName());
        }
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        fileName.sort(sorter);
        return fileName;
    }

    public synchronized ArrayList<String> getAboChannelList() {
        ArrayList<String> sender = new ArrayList<String>();
        sender.add("");
        for (AboData abo : this) {
            String s = abo.getChannel();
            ArrayList<String> channelFilterList = new ArrayList<String>();
            String channelFilter = abo.getChannel();
            if (channelFilter != null) {
                if (channelFilter.contains(",")) {
                    channelFilterList.addAll(Arrays.asList(channelFilter.replace(" ", "").split(",")));
                } else {
                    channelFilterList.add(channelFilter);
                }
                channelFilterList.stream().forEach(st -> {
                    st = st.trim();
                });
            }
            for (String sf : channelFilterList) {
                if (sf.isEmpty() || sender.contains(sf)) continue;
                sender.add(sf);
            }
        }
        sender.sort(sorter);
        return sender;
    }

    public synchronized ArrayList<String> getAboNameList() {
        ArrayList<String> name = new ArrayList<String>();
        name.add("");
        for (AboData abo : this) {
            String s = abo.getName();
            if (name.contains(s)) continue;
            name.add(abo.getName());
        }
        name.sort(sorter);
        return name;
    }

    public ObservableList<AboData> getUndoList() {
        return this.undoList;
    }

    public synchronized void addAbosToUndoList(List<AboData> list) {
        this.undoList.clear();
        this.undoList.addAll((Collection<AboData>)list);
    }

    public synchronized void undoAbos() {
        if (this.undoList.isEmpty()) {
            return;
        }
        this.addAll(this.undoList);
        this.undoList.clear();
        this.notifyChanges();
    }
}

