/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.abo;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboData;
import de.p2tools.mtplayer.controller.data.abo.AboList;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filter.FilmFilterCheck;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;

public class AboFactory {
    private AboFactory() {
    }

    public static void checkAbosSetData() {
        P2Log.sysLog("SetData der Abos pr\u00fcfen");
        ProgData progData = ProgData.getInstance();
        progData.aboList.forEach(a -> {
            SetData setData = a.getSetData();
            if (setData == null || !AboFactory.isSetDataForAbo(setData.getId())) {
                SetData getSet = progData.setDataList.getSetDataForAbo(setData == null ? "" : setData.getId());
                a.setSetData(getSet);
            }
        });
    }

    public static boolean isSetDataForAbo(String id) {
        boolean ret = false;
        for (SetData s : ProgData.getInstance().setDataList) {
            if (!s.isAbo() || !s.getId().equals(id)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static SetData getSetData(ProgData progData, AboData aboData) {
        if (aboData.getSetData() == null) {
            aboData.setSetData(progData.setDataList.getSetDataForAbo(""));
        }
        return aboData.getSetData();
    }

    public static String getSourceText(AboData abo) {
        if (abo.getList() == 0) {
            return "Film/Audio";
        }
        if (abo.getList() == 1) {
            return "Film";
        }
        return "Audio";
    }

    public static AboData findAbo(boolean audio, FilmData film) {
        if (film.isLive()) {
            return null;
        }
        film.setLowerCase();
        AboData aboData = ProgData.getInstance().aboList.stream().filter(abo -> abo.getList() == 0 || audio && abo.getList() == 2 || !audio && abo.getList() == 1).filter(abo -> FilmFilterCheck.checkFilterMatch(abo.fChannel, abo.fTheme, abo.fThemeTitle, abo.fTitle, abo.fSomewhere, film)).findFirst().orElse(null);
        film.clearLowerCase();
        return aboData;
    }

    public static synchronized void setAboForList() {
        AboFactory.setAboForList(false, ProgData.getInstance().filmList);
        AboFactory.setAboForList(true, ProgData.getInstance().audioList);
    }

    public static synchronized void setAboForList(boolean audio, Filmlist<FilmDataMTP> filmlist) {
        P2Duration.counterStart("setAboForFilmlist");
        AboList aboList = ProgData.getInstance().aboList;
        aboList.removeIf(AboData::isEmpty);
        if (aboList.isEmpty()) {
            filmlist.forEach(film -> {
                film.arr[16] = "";
                film.setAbo(null);
            });
            return;
        }
        aboList.forEach(abo -> {
            if (abo.getName().isEmpty()) {
                abo.setName("Abo " + abo.getNo());
            }
        });
        filmlist.forEach(f -> AboFactory.assignAboToFilm(audio, f));
        P2Duration.counterStop("setAboForFilmlist");
    }

    private static void assignAboToFilm(boolean audio, FilmDataMTP film) {
        AboData abo = AboFactory.findAbo(audio, film);
        if (abo == null) {
            film.arr[16] = "";
            film.setAbo(null);
        } else if (!abo.isActive()) {
            film.arr[16] = abo.getName() + " [ausgeschaltet]";
            film.setAbo(null);
        } else if (!FilmFilterCheck.checkMaxDays(abo.getTimeRange(), film.filmDate.getTime())) {
            film.arr[16] = abo.getName() + " [zu alt]";
            film.setAbo(null);
        } else if (!FilmFilterCheck.checkMatchLengthMin(abo.getMinDurationMinute(), film.getDurationMinute())) {
            film.arr[16] = abo.getName() + " [zu kurz]";
            film.setAbo(null);
        } else if (!FilmFilterCheck.checkMatchLengthMax(abo.getMaxDurationMinute(), film.getDurationMinute())) {
            film.arr[16] = abo.getName() + " [zu lang]";
            film.setAbo(null);
        } else {
            film.arr[16] = abo.getName();
            film.setAbo(abo);
        }
    }

    public static AboData aboExistsAlready(AboData checkAbo, boolean no) {
        for (AboData dataAbo : ProgData.getInstance().aboList) {
            if (!AboFactory.checkAboExist(dataAbo.getChannel(), checkAbo.getChannel(), true) || !(dataAbo.isThemeExact() || checkAbo.isThemeExact() ? AboFactory.checkAboExist(dataAbo.getTheme(), checkAbo.getTheme(), true) : AboFactory.checkAboExist(dataAbo.getTheme(), checkAbo.getTheme(), false)) || !AboFactory.checkAboExist(dataAbo.getThemeTitle(), checkAbo.getThemeTitle(), false) || !AboFactory.checkAboExist(dataAbo.getTitle(), checkAbo.getTitle(), false) || !AboFactory.checkAboExist(dataAbo.getSomewhere(), checkAbo.getSomewhere(), false) || dataAbo.getList() != checkAbo.getList()) continue;
            if (no) {
                if (dataAbo.getNo() == checkAbo.getNo()) continue;
                return dataAbo;
            }
            return dataAbo;
        }
        return null;
    }

    private static boolean checkAboExist(String aboExist, String aboCheck, boolean exact) {
        aboCheck = aboCheck.toLowerCase().trim();
        aboExist = aboExist.toLowerCase().trim();
        if (aboCheck.isEmpty() && aboExist.isEmpty()) {
            return true;
        }
        return exact ? aboCheck.equals(aboExist) : aboCheck.contains(aboExist);
    }
}

