/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller.data.abo;

import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.abo.AboDataProps;
import de.p2tools.mtplayer.controller.data.setdata.SetData;
import de.p2tools.p2lib.mediathek.filter.Filter;

public class AboData
extends AboDataProps {
    public int nr;
    public Filter fChannel = new Filter();
    public Filter fTheme = new Filter();
    public Filter fThemeTitle = new Filter();
    public Filter fTitle = new Filter();
    public Filter fSomewhere = new Filter();

    public AboData() {
        this.setActive(true);
        this.setResolution("normal");
        this.initFilter();
    }

    public AboData(ProgData progData, int audio, String name, String channel, String theme, boolean themeIsExact, String themeTitle, String title, String somewhere, int timeRange, int minDurationMinute, int maxDurationMinute, String destination) {
        this.setActive(true);
        this.setResolution("normal");
        this.initFilter();
        this.setName(name);
        this.setList(audio);
        this.setChannel(channel);
        this.setTheme(theme);
        this.setThemeExact(themeIsExact);
        this.setThemeTitle(themeTitle);
        this.setTitle(title);
        this.setSomewhere(somewhere);
        this.setTimeRange(timeRange);
        this.setMinDurationMinute(minDurationMinute);
        this.setMaxDurationMinute(maxDurationMinute);
        this.setAboSubDir(destination);
        this.setSetData(progData.setDataList.getSetDataForAbo(""));
    }

    void initAbo(ProgData progData, int no) {
        SetData setData = progData.setDataList.getSetDataForAbo(this.getSetDataId());
        this.setSetData(setData);
        this.setSetDataId(setData == null ? "" : setData.getId());
        this.setNo(no);
    }

    private void initFilter() {
        this.channelProperty().addListener(l -> this.createFilter());
        this.themeProperty().addListener(l -> this.createFilter());
        this.themeExactProperty().addListener(l -> this.createFilter());
        this.themeTitleProperty().addListener(l -> this.createFilter());
        this.titleProperty().addListener(l -> this.createFilter());
        this.somewhereProperty().addListener(l -> this.createFilter());
    }

    private void createFilter() {
        this.fChannel = new Filter(this.getChannel(), true);
        this.fTheme = new Filter(this.getTheme(), this.isThemeExact(), true);
        this.fThemeTitle = new Filter(this.getThemeTitle(), true);
        this.fTitle = new Filter(this.getTitle(), true);
        this.fSomewhere = new Filter(this.getSomewhere(), true);
    }

    public boolean isEmpty() {
        return this.getChannel().isEmpty() && this.getTheme().isEmpty() && this.getThemeTitle().isEmpty() && this.getTitle().isEmpty() && this.getSomewhere().isEmpty();
    }

    public void copyToMe(AboData abo) {
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i].setValue(abo.properties[i].getValue());
        }
        this.setSetData(abo.getSetData());
    }

    public AboData getCopy() {
        AboData ret = new AboData();
        for (int i = 0; i < this.properties.length; ++i) {
            ret.properties[i].setValue(this.properties[i].getValue());
        }
        ret.setSetData(this.getSetData());
        return ret;
    }
}

