/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller;

import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.mtplayer.controller.config.ProxyFactory;
import de.p2tools.mtplayer.controller.data.bookmark.BookmarkLoadSaveFactory;
import de.p2tools.mtplayer.controller.data.setdata.SetImportFactory;
import de.p2tools.mtplayer.controller.filter.film.AudioFilterSamples;
import de.p2tools.mtplayer.controller.filter.film.FilmFilterSamples;
import de.p2tools.mtplayer.controller.update.ProgConfigUpdate;
import de.p2tools.mtplayer.controller.update.WhatsNewFactory;
import de.p2tools.mtplayer.gui.startdialog.StartDialogController;
import de.p2tools.p2lib.P2LibInit;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigReadFile;
import de.p2tools.p2lib.tools.P2ToolsRaspberry;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.application.Platform;

public class ProgStartBeforeGui {
    private ProgStartBeforeGui() {
    }

    public static void workBeforeGui() {
        ProgData.raspberry = P2ToolsRaspberry.isRaspberry();
        boolean load = ProgStartBeforeGui.loadAll();
        ProgStartBeforeGui.initLib();
        if (!load) {
            P2Duration.onlyPing("Erster Start");
            ProgData.firstProgramStart = true;
            ProgConfigUpdate.setUpdateDone();
            WhatsNewFactory.setLastShownToNow();
            ProgData.getInstance().replaceList.init();
            ProgData.getInstance().offerList.init();
            ProgData.getInstance().utDataList.init(true);
            ProgData.getInstance().markDataList.init(false);
            StartDialogController startDialogController = new StartDialogController();
            if (!startDialogController.isOk()) {
                Platform.exit();
                System.exit(0);
            }
            P2Duration.onlyPing("Erster Start: PSet");
            SetImportFactory.getStandardSet(null);
            P2Duration.onlyPing("Erster Start: PSet geladen");
            FilmFilterSamples.addStandardFilter();
            AudioFilterSamples.addStandardFilter();
            P2Duration.onlyPing("Erster Start: CleaningList init");
            ProgData.getInstance().cleaningDataListMedia.initList();
            ProgData.getInstance().cleaningDataListPropose.initList();
        }
        ProgData.gui = ProgConfig.SYSTEM_SIZE_GUI.getValue();
        ProgData.dialog = ProgConfig.FILM__FILTER_DIALOG_SIZE.getValueSafe();
        P2Log.sysLog("History-Listen laden");
        ProgData.getInstance().historyList.loadList();
        ProgData.getInstance().historyListAbos.loadList();
        BookmarkLoadSaveFactory.loadList();
        if (ProgData.getInstance().utDataList.isEmpty()) {
            ProgData.getInstance().utDataList.init(true);
        }
        if (ProgData.getInstance().markDataList.isEmpty()) {
            ProgData.getInstance().markDataList.init(false);
        }
    }

    private static void initLib() {
        P2LibInit.initLib(ProgData.getInstance().primaryStage, "MTPlayer", "", ProgConfig.SYSTEM_DARK_THEME, ProgConfig.SYSTEM_BLACK_WHITE_ICON, ProgConfig.SYSTEM_THEME_CHANGED, ProgConfig.SYSTEM_FILTER_REG_EX_ONLY_CONTAIN, "de/p2tools/mtplayer/mtfx.css", "de/p2tools/mtplayer/mtfx-dark.css", ProgConfig.SYSTEM_FONT_SIZE, "", MTPlayerFactory.getOwnIconPath(), ProgData.debug, ProgData.duration);
        MTPlayerFactory.setProgramIcon();
    }

    private static boolean loadAll() {
        ArrayList<String> logList = new ArrayList<String>();
        boolean ret = ProgStartBeforeGui.load(logList);
        if (ProgConfig.SYSTEM_LOG_ON.getValue().booleanValue()) {
            P2Logger.setFileHandler(ProgInfos.getLogDirectory_String());
        }
        P2Log.sysLog(logList);
        if (!ret) {
            P2Log.sysLog("Weder Konfig noch Backup konnte geladen werden!");
            ProgStartBeforeGui.clearTheConfigs();
        }
        return ret;
    }

    private static boolean load(ArrayList<String> logList) {
        Path xmlFilePath = ProgInfos.getSettingsFile();
        P2Duration.onlyPing("ProgStartFactory.loadProgConfigData");
        try {
            if (!Files.exists(xmlFilePath, new LinkOption[0])) {
                logList.add("Konfig existiert nicht!");
                return false;
            }
            logList.add("Programmstart und ProgConfig laden von: " + String.valueOf(xmlFilePath));
            ConfigFile configFile = new ConfigFile(xmlFilePath.toString(), true){

                @Override
                public void clearConfigFile() {
                    ProgStartBeforeGui.clearTheConfigs();
                }
            };
            ProgConfig.addConfigData(configFile, false);
            boolean ok = ConfigReadFile.readConfig(configFile);
            ProgData.getInstance().worker.workOnConfigLoaded();
            if (ok) {
                ProgStartBeforeGui.initAfterLoad();
                logList.add("Konfig wurde geladen!");
                return true;
            }
            logList.add("Konfig konnte nicht geladen werden!");
            return false;
        }
        catch (Exception ex) {
            logList.add(ex.getLocalizedMessage());
            return false;
        }
    }

    private static void clearTheConfigs() {
        ProgData progData = ProgData.getInstance();
        progData.setDataList.clear();
        progData.replaceList.clear();
        progData.offerList.clear();
        progData.utDataList.clear();
        progData.markDataList.clear();
        progData.aboList.clear();
        progData.downloadList.clear();
        progData.blackList.clear();
        progData.cleaningDataListMedia.clear();
        progData.cleaningDataListPropose.clear();
    }

    private static void initAfterLoad() {
        ProgData.getInstance().downloadList.initDownloads();
        ProgData.getInstance().aboList.initAboList();
        ProgData.getInstance().cleaningDataListMedia.initList();
        ProgData.getInstance().cleaningDataListPropose.initList();
        if (ProgData.getInstance().filterWorkerFilm.getFilmFilterList().isEmpty()) {
            FilmFilterSamples.addStandardFilter();
        }
        if (ProgData.getInstance().filterWorkerAudio.getFilmFilterList().isEmpty()) {
            AudioFilterSamples.addStandardFilter();
        }
        ProgConfigUpdate.update();
        ProgColorList.setColorTheme();
        ProxyFactory.initProxy();
    }
}

