/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.controller;

import de.p2tools.mtplayer.controller.ProgSave;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.worker.Busy;
import de.p2tools.mtplayer.gui.dialog.QuitDialogController;
import de.p2tools.p2lib.checkforactinfos.FoundHttpDownload;
import de.p2tools.p2lib.guitools.P2GuiSize;
import de.p2tools.p2lib.tools.P2ShutDown;
import de.p2tools.p2lib.tools.log.P2LogMessage;
import javafx.application.Platform;

public class ProgQuit {
    private ProgQuit() {
    }

    public static void quit() {
        ProgQuit.save(false);
    }

    public static void quitShutDown() {
        ProgQuit.save(true);
    }

    public static void quit(boolean startWithWaiting) {
        ProgData progData = ProgData.getInstance();
        if (progData.downloadList.countStartedAndRunningDownloads() > 0 || FoundHttpDownload.downloadRunning > 0) {
            new QuitDialogController(startWithWaiting);
        } else {
            ProgQuit.save(false);
        }
    }

    private static void save(boolean shutDown) {
        ProgData.busy.busyOnFx(Busy.BUSY_SRC.GUI, "Speichern:", -1.0, false);
        if (ProgData.getInstance().primaryStage.isShowing()) {
            P2GuiSize.getSize(ProgConfig.SYSTEM_SIZE_GUI, ProgData.getInstance().primaryStage);
        }
        Platform.runLater(() -> {
            ProgQuit.stopAllDownloads();
            ProgQuit.writeTabSettings();
            ProgSave.saveAll();
            P2LogMessage.endMsg();
            if (shutDown) {
                P2ShutDown.shutDown(ProgConfig.SYSTEM_SHUT_DOWN_CALL.getValueSafe());
            }
            ProgQuit.exitProg();
        });
    }

    private static void exitProg() {
        Platform.exit();
        System.exit(0);
    }

    private static void stopAllDownloads() {
        ProgData.getInstance().downloadList.forEach(download -> {
            if (download.isStateStartedRun()) {
                download.stopDownload(false);
            }
        });
    }

    private static void writeTabSettings() {
        ProgData progData = ProgData.getInstance();
        ProgConfig.SYSTEM_GUI_LAST_START_WAS_MAXIMISED.set(progData.primaryStage.isMaximized());
        progData.filmGuiController.saveTable();
        progData.audioGuiController.saveTable();
        progData.liveFilmGuiController.saveTable();
        progData.downloadGuiController.saveTable();
        progData.aboGuiController.saveTable();
    }
}

