/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.data.blackdata.BlacklistFactory;
import de.p2tools.mtplayer.controller.load.LoadFactory;
import de.p2tools.mtplayer.gui.configdialog.ConfigDialogController;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2WindowIcon;

public class MTPlayerFactory {
    private MTPlayerFactory() {
    }

    public static String getOwnIconPath() {
        if (ProgConfig.SYSTEM_USE_OWN_PROGRAM_ICON.getValue().booleanValue()) {
            return ProgConfig.SYSTEM_PROGRAM_ICON_PATH.getValueSafe();
        }
        return "";
    }

    public static void setProgramIcon() {
        if (ProgConfig.SYSTEM_USE_OWN_PROGRAM_ICON.getValue().booleanValue()) {
            P2WindowIcon.setStageIcon(ProgConfig.SYSTEM_PROGRAM_ICON_PATH.getValueSafe());
        } else {
            P2WindowIcon.setStageIcon("");
        }
    }

    public static void centerGui() {
        ProgData.getInstance().primaryStage.centerOnScreen();
    }

    public static void loadFilmlist() {
        LoadFactory.updateLists(true);
    }

    public static void updateFilmlist() {
        LoadFactory.updateLists(false);
    }

    public static void minimizeGui() {
        ProgData.getInstance().primaryStage.setIconified(true);
        P2DialogExtra.getDialogList().forEach(p2Dialog -> p2Dialog.getStage().setIconified(true));
    }

    public static void setFilter() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            ProgConfig.FILM__FILTER_IS_SHOWING.setValue(ProgConfig.FILM__FILTER_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            ProgConfig.AUDIO__FILTER_IS_SHOWING.setValue(ProgConfig.AUDIO__FILTER_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            ProgConfig.LIVE_FILM__FILTER_IS_SHOWING.setValue(ProgConfig.LIVE_FILM__FILTER_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.setValue(ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_ABO_ON.get()) {
            ProgConfig.ABO__FILTER_IS_SHOWING.setValue(ProgConfig.ABO__FILTER_IS_SHOWING.getValue() == false);
        }
    }

    public static void setInfos() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            ProgConfig.FILM__INFO_IS_SHOWING.setValue(ProgConfig.FILM__INFO_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            ProgConfig.AUDIO__INFO_IS_SHOWING.setValue(ProgConfig.AUDIO__INFO_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            ProgConfig.LIVE_FILM__INFO_IS_SHOWING.setValue(ProgConfig.LIVE_FILM__INFO_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgConfig.DOWNLOAD__INFO_IS_SHOWING.setValue(ProgConfig.DOWNLOAD__INFO_IS_SHOWING.getValue() == false);
        } else if (MTPlayerController.TAB_ABO_ON.get()) {
            ProgConfig.ABO__INFO_IS_SHOWING.setValue(ProgConfig.ABO__INFO_IS_SHOWING.getValue() == false);
        }
    }

    public static void showFilmInfos() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            ProgData.getInstance().filmGuiController.showFilmInfo();
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            ProgData.getInstance().audioGuiController.showFilmInfo();
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            ProgData.getInstance().liveFilmGuiController.showFilmInfo();
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgData.getInstance().downloadGuiController.showFilmInfo();
        }
    }

    public static void copyTheme() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            ProgData.getInstance().filmGuiController.copyFilmThemeTitle(true);
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            ProgData.getInstance().audioGuiController.copyFilmThemeTitle(true);
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            ProgData.getInstance().liveFilmGuiController.copyFilmThemeTitle(true);
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgData.getInstance().downloadGuiController.copyFilmThemeTitle(true);
        }
    }

    public static void copyTitle() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            ProgData.getInstance().filmGuiController.copyFilmThemeTitle(false);
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            ProgData.getInstance().audioGuiController.copyFilmThemeTitle(false);
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            ProgData.getInstance().liveFilmGuiController.copyFilmThemeTitle(false);
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgData.getInstance().downloadGuiController.copyFilmThemeTitle(false);
        }
    }

    public static void addBlacklist() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.FILM);
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.AUDIO);
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            BlacklistFactory.addBlackFilm(BlacklistFactory.BLACK_SRC.DOWNLOAD);
        }
    }

    public static void addBlacklistTheme() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            BlacklistFactory.addBlackThemeFilm(BlacklistFactory.BLACK_SRC.FILM);
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            BlacklistFactory.addBlackThemeFilm(BlacklistFactory.BLACK_SRC.AUDIO);
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            BlacklistFactory.addBlackThemeDownload();
        }
    }

    public static void showBlacklist() {
        new ConfigDialogController(ProgData.getInstance(), true);
    }

    public static void setMediaCollection() {
        if (MTPlayerController.TAB_FILM_ON.get()) {
            ProgData.getInstance().filmGuiController.searchFilmInMediaCollection();
        } else if (MTPlayerController.TAB_AUDIO_ON.get()) {
            ProgData.getInstance().audioGuiController.searchFilmInMediaCollection();
        } else if (MTPlayerController.TAB_LIVE_ON.get()) {
            ProgData.getInstance().liveFilmGuiController.searchFilmInMediaCollection();
        } else if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgData.getInstance().downloadGuiController.searchFilmInMediaCollection();
        }
    }

    public static void undoDels() {
        if (MTPlayerController.TAB_DOWNLOAD_ON.get()) {
            ProgData.getInstance().downloadList.undoDownloads();
        } else if (MTPlayerController.TAB_ABO_ON.get()) {
            ProgData.getInstance().aboList.undoAbos();
        }
    }
}

