/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.MTPlayerFactory;
import de.p2tools.mtplayer.MTPlayerMenu;
import de.p2tools.mtplayer.controller.config.PEvents;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgIcons;
import de.p2tools.mtplayer.controller.load.LoadFactory;
import de.p2tools.mtplayer.gui.AboGui;
import de.p2tools.mtplayer.gui.AudioGui;
import de.p2tools.mtplayer.gui.DownloadGui;
import de.p2tools.mtplayer.gui.FilmGui;
import de.p2tools.mtplayer.gui.LiveFilmGui;
import de.p2tools.mtplayer.gui.StatusBarController;
import de.p2tools.mtplayer.gui.filter.FastFilter;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;

public class MTPlayerController
extends StackPane {
    public static BooleanProperty TAB_FILM_ON = new SimpleBooleanProperty(Boolean.FALSE);
    public static BooleanProperty TAB_AUDIO_ON = new SimpleBooleanProperty(Boolean.FALSE);
    public static BooleanProperty TAB_LIVE_ON = new SimpleBooleanProperty(Boolean.FALSE);
    public static BooleanProperty TAB_DOWNLOAD_ON = new SimpleBooleanProperty(Boolean.FALSE);
    public static BooleanProperty TAB_ABO_ON = new SimpleBooleanProperty(Boolean.FALSE);
    private final Button btnFilmlist = new Button("Filmliste");
    private final Button btnFilm = new Button("Filme");
    private final Button btnAudio = new Button("Audios");
    private final Button btnLive = new Button("Live");
    private final Button btnDownload = new Button("Downloads");
    private final Button btnAbo = new Button("Abos");
    private final StackPane stackPaneFast = new StackPane();
    private final FastFilter fastFilterFilm = new FastFilter(false);
    private final FastFilter fastFilterAudio = new FastFilter(true);
    private final BorderPane borderPane = new BorderPane();
    private final StackPane stackPaneCont = new StackPane();
    private StatusBarController statusBarController;
    private SplitPane splitPaneFilm;
    private SplitPane splitPaneAudio;
    private SplitPane splitPaneLiveFilm;
    private SplitPane splitPaneDownload;
    private SplitPane splitPaneAbo;
    private final ProgData progData;
    private final FilmGui filmGui = new FilmGui();
    private final AudioGui audioGui = new AudioGui();
    private final LiveFilmGui liveFilmGui = new LiveFilmGui();
    private final DownloadGui downloadGui = new DownloadGui();
    private final AboGui aboGui = new AboGui();

    public MTPlayerController() {
        this.progData = ProgData.getInstance();
        this.init();
    }

    private void init() {
        try {
            this.stackPaneFast.getChildren().addAll((Node[])new Node[]{this.fastFilterFilm, this.fastFilterAudio});
            this.stackPaneFast.setAlignment(Pos.CENTER_RIGHT);
            TilePane tilePaneButton = new TilePane();
            tilePaneButton.setPrefColumns(4);
            tilePaneButton.setHgap(15.0);
            tilePaneButton.setPadding(new Insets(0.0));
            tilePaneButton.setAlignment(Pos.CENTER);
            tilePaneButton.getChildren().addAll((Node[])new Node[]{this.btnFilm, this.btnAudio, this.btnLive, this.btnDownload, this.btnAbo});
            HBox hBoxTop = new HBox();
            hBoxTop.setPadding(new Insets(2.0, 10.0, 2.0, 10.0));
            hBoxTop.setSpacing(10.0);
            hBoxTop.setAlignment(Pos.CENTER);
            HBox.setHgrow(tilePaneButton, Priority.ALWAYS);
            HBox.setHgrow(this.stackPaneFast, Priority.NEVER);
            hBoxTop.getChildren().addAll((Node[])new Node[]{this.btnFilmlist, tilePaneButton, this.stackPaneFast, new MTPlayerMenu()});
            this.splitPaneFilm = this.filmGui.pack();
            this.splitPaneAudio = this.audioGui.pack();
            this.splitPaneLiveFilm = this.liveFilmGui.pack();
            this.splitPaneDownload = this.downloadGui.pack();
            this.splitPaneAbo = this.aboGui.pack();
            this.stackPaneCont.getChildren().addAll((Node[])new Node[]{this.splitPaneFilm, this.splitPaneAudio, this.splitPaneLiveFilm, this.splitPaneDownload, this.splitPaneAbo});
            this.statusBarController = new StatusBarController(this.progData);
            this.statusBarController.visibleProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_ON);
            this.statusBarController.managedProperty().bind(ProgConfig.SYSTEM_STATUS_BAR_ON);
            this.borderPane.setTop(hBoxTop);
            this.borderPane.setCenter(this.stackPaneCont);
            this.borderPane.setBottom(this.statusBarController);
            this.setPadding(new Insets(0.0));
            this.getChildren().addAll((Node[])new Node[]{this.borderPane, this.progData.maskerPane});
            this.initMaskerPane();
            this.initButtonFilmList();
            this.initButton();
            if (ProgData.autoMode) {
                this.selPanelDownload();
            } else {
                this.selPanelFilm();
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(597841023, ex);
        }
    }

    private void initMaskerPane() {
        StackPane.setAlignment(this.progData.maskerPane, Pos.CENTER);
        this.progData.maskerPane.setPadding(new Insets(4.0, 1.0, 1.0, 1.0));
        this.progData.maskerPane.toFront();
        Button btnStop = this.progData.maskerPane.getButton();
        this.progData.maskerPane.setButtonText("");
        btnStop.setGraphic(ProgIcons.ICON_BUTTON_CLEAR.getImageView());
        btnStop.setOnAction(a -> P2LoadConst.stop.set(true));
    }

    private void initButtonFilmList() {
        this.btnFilmlist.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnFilmlist.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-4"});
        this.btnFilmlist.setTooltip(new Tooltip("Eine neue Filmliste laden.\nWenn die Filmliste nicht zu alt ist, wird nur ein Update geladen. [" + ProgConfig.SHORTCUT_UPDATE_FILMLIST.getValueSafe() + "]\nMit der rechten Maustaste wird immer die komplette Filmliste geladen. [" + ProgConfig.SHORTCUT_LOAD_FILMLIST.getValueSafe() + "]"));
        this.btnFilmlist.setOnAction(e -> LoadFactory.updateLists(false));
        this.btnFilmlist.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                LoadFactory.updateLists(true);
            } else if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
                this.progData.checkForNewFilmlist.check();
            }
        });
        this.progData.checkForNewFilmlist.foundNewListProperty().addListener((u, o, n) -> {
            if (this.progData.checkForNewFilmlist.isFoundNewList()) {
                this.btnFilmlist.getStyleClass().add("buttonLoadFilmlistNewList");
            } else {
                this.btnFilmlist.getStyleClass().remove("buttonLoadFilmlistNewList");
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_FILMLIST_LOAD_FINISHED){

            @Override
            public void pingGui() {
                if (MTPlayerController.this.stackPaneCont.getChildren().isEmpty()) {
                    return;
                }
                MTPlayerController.this.setFocus();
            }
        });
    }

    private void initButton() {
        ProgConfig.FAST_FILM_SEARCH_ON.addListener((u, o, n) -> this.setButtonStyle());
        ProgConfig.FAST_AUDIO_SEARCH_ON.addListener((u, o, n) -> this.setButtonStyle());
        ProgConfig.SYSTEM_USE_AUDIOLIST.addListener((u, o, n) -> {
            this.fastFilterAudio.setManaged(ProgConfig.SYSTEM_USE_AUDIOLIST.get());
            if (TAB_AUDIO_ON.get()) {
                this.selPanelFilm();
            } else {
                this.setButtonStyle();
            }
        });
        ProgConfig.SYSTEM_USE_LIVE.addListener((u, o, n) -> {
            if (TAB_LIVE_ON.get()) {
                this.selPanelFilm();
            }
        });
        this.btnFilm.setTooltip(new Tooltip("Filme anzeigen"));
        this.btnFilm.setOnAction(e -> this.selPanelFilm());
        this.btnFilm.setMaxWidth(Double.MAX_VALUE);
        this.btnAudio.setTooltip(new Tooltip("Audios anzeigen"));
        this.btnAudio.setOnAction(e -> this.selPanelAudio());
        this.btnAudio.setMaxWidth(Double.MAX_VALUE);
        this.btnAudio.visibleProperty().bind(ProgConfig.SYSTEM_USE_AUDIOLIST);
        this.btnAudio.managedProperty().bind(ProgConfig.SYSTEM_USE_AUDIOLIST);
        this.btnLive.setTooltip(new Tooltip("Live-Filme suchen"));
        this.btnLive.setOnAction(e -> this.selPanelLiveFilm());
        this.btnLive.setMaxWidth(Double.MAX_VALUE);
        this.btnLive.visibleProperty().bind(ProgConfig.SYSTEM_USE_LIVE);
        this.btnLive.managedProperty().bind(this.btnLive.visibleProperty());
        this.btnDownload.setTooltip(new Tooltip("Downloads anzeigen"));
        this.btnDownload.setOnAction(e -> this.selPanelDownload());
        this.btnDownload.setMaxWidth(Double.MAX_VALUE);
        this.btnAbo.setTooltip(new Tooltip("Abos anzeigen"));
        this.btnAbo.setOnAction(e -> this.selPanelAbo());
        this.btnAbo.setMaxWidth(Double.MAX_VALUE);
        this.btnFilm.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || !TAB_FILM_ON.get()) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnAudio.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || !TAB_AUDIO_ON.get()) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnLive.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || !TAB_LIVE_ON.get()) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnDownload.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || !TAB_DOWNLOAD_ON.get()) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
        this.btnAbo.setOnMouseClicked(mouseEvent -> {
            if (this.progData.maskerPane.isVisible() || !TAB_ABO_ON.get()) {
                return;
            }
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                MTPlayerFactory.setInfos();
            }
        });
    }

    private void selPanelFilm() {
        if (TAB_FILM_ON.get()) {
            MTPlayerFactory.setFilter();
            return;
        }
        this.setTabFilmOn();
        this.setButtonStyle();
        this.splitPaneFilm.toFront();
        this.progData.filmGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
    }

    private void selPanelAudio() {
        if (TAB_AUDIO_ON.get()) {
            MTPlayerFactory.setFilter();
            return;
        }
        this.setTabAudioOn();
        this.setButtonStyle();
        this.splitPaneAudio.toFront();
        this.progData.audioGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
    }

    private void selPanelLiveFilm() {
        if (TAB_LIVE_ON.get()) {
            MTPlayerFactory.setFilter();
            return;
        }
        this.setTabLiveOn();
        this.setButtonStyle();
        this.splitPaneLiveFilm.toFront();
        this.progData.liveFilmGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
    }

    private void selPanelDownload() {
        if (TAB_DOWNLOAD_ON.get()) {
            MTPlayerFactory.setFilter();
            return;
        }
        this.setTabDownloadOn();
        this.setButtonStyle();
        this.splitPaneDownload.toFront();
        this.progData.downloadGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
    }

    private void selPanelAbo() {
        if (TAB_ABO_ON.get()) {
            MTPlayerFactory.setFilter();
            return;
        }
        this.setTabAboOn();
        this.setButtonStyle();
        this.splitPaneAbo.toFront();
        this.progData.aboGuiController.isShown();
        this.statusBarController.setStatusbarIndex();
    }

    private void setButtonStyle() {
        this.btnFilm.getStyleClass().clear();
        this.btnAudio.getStyleClass().clear();
        this.btnLive.getStyleClass().clear();
        this.btnDownload.getStyleClass().clear();
        this.btnAbo.getStyleClass().clear();
        this.fastFilterFilm.setVisible(false);
        this.fastFilterAudio.setVisible(false);
        if (TAB_FILM_ON.get()) {
            this.fastFilterFilm.setVisible(true);
            this.btnFilm.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnFilm.getStyleClass().add("btnTabTop");
        }
        if (TAB_AUDIO_ON.get()) {
            this.fastFilterAudio.setVisible(true);
            this.btnAudio.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnAudio.getStyleClass().add("btnTabTop");
        }
        if (TAB_LIVE_ON.get()) {
            this.btnLive.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnLive.getStyleClass().add("btnTabTop");
        }
        if (TAB_DOWNLOAD_ON.get()) {
            this.btnDownload.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnDownload.getStyleClass().add("btnTabTop");
        }
        if (TAB_ABO_ON.get()) {
            this.btnAbo.getStyleClass().add("btnTabTop-sel");
        } else {
            this.btnAbo.getStyleClass().add("btnTabTop");
        }
        if (ProgConfig.FAST_FILM_SEARCH_ON.get() || ProgConfig.FAST_AUDIO_SEARCH_ON.get() && ProgConfig.SYSTEM_USE_AUDIOLIST.get()) {
            this.btnFilm.getStyleClass().add("btnTabTopS");
            this.btnAudio.getStyleClass().add("btnTabTopS");
            this.btnLive.getStyleClass().add("btnTabTopS");
            this.btnDownload.getStyleClass().add("btnTabTopS");
            this.btnAbo.getStyleClass().add("btnTabTopS");
        }
    }

    public void setFocus() {
        if (TAB_FILM_ON.get()) {
            this.progData.filmGuiController.isShown();
        }
        if (TAB_AUDIO_ON.get()) {
            this.progData.audioGuiController.isShown();
        }
        if (TAB_LIVE_ON.get()) {
            this.progData.liveFilmGuiController.isShown();
        }
        if (TAB_DOWNLOAD_ON.get()) {
            this.progData.downloadGuiController.isShown();
        }
        if (TAB_ABO_ON.get()) {
            this.progData.aboGuiController.isShown();
        }
    }

    private void setTabFilmOn() {
        this.clearTab();
        TAB_FILM_ON.set(true);
    }

    private void setTabAudioOn() {
        this.clearTab();
        TAB_AUDIO_ON.set(true);
    }

    private void setTabLiveOn() {
        this.clearTab();
        TAB_LIVE_ON.set(true);
    }

    private void setTabDownloadOn() {
        this.clearTab();
        TAB_DOWNLOAD_ON.set(true);
    }

    private void setTabAboOn() {
        this.clearTab();
        TAB_ABO_ON.set(true);
    }

    private void clearTab() {
        TAB_FILM_ON.set(false);
        TAB_AUDIO_ON.set(false);
        TAB_LIVE_ON.set(false);
        TAB_DOWNLOAD_ON.set(false);
        TAB_ABO_ON.set(false);
    }
}

