/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer;

import de.p2tools.mtplayer.MTPlayerController;
import de.p2tools.mtplayer.controller.ProgQuit;
import de.p2tools.mtplayer.controller.ProgStartAfterGui;
import de.p2tools.mtplayer.controller.ProgStartBeforeGui;
import de.p2tools.mtplayer.controller.config.PShortKeyFactory;
import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.config.ProgData;
import de.p2tools.mtplayer.controller.config.ProgInfos;
import de.p2tools.p2lib.P2LibInit;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2GuiSize;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.P2Lock;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class MTPlayer
extends Application {
    private Stage primaryStage;
    private ProgData progData;
    private boolean done = false;

    public static void main(String[] args2) {
        MTPlayer.launch(args2);
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        P2Duration.counterStart("start");
        this.progData = ProgData.getInstance();
        this.progData.primaryStage = primaryStage;
        ProgStartBeforeGui.workBeforeGui();
        String xmlFilePath = ProgInfos.getLockFileStr();
        if (ProgConfig.SYSTEM_ONLY_ONE_INSTANCE.getValue().booleanValue() && !P2Lock.getLockInstance(xmlFilePath)) {
            return;
        }
        this.initRootLayout();
        ProgStartAfterGui.doWorkAfterGui();
        P2Duration.onlyPing("Gui steht!");
        P2Duration.counterStop("start");
    }

    private void initRootLayout() {
        try {
            this.progData.mtPlayerController = new MTPlayerController();
            Scene scene = new Scene(this.progData.mtPlayerController, P2GuiSize.getSceneSize(ProgConfig.SYSTEM_SIZE_GUI, true), P2GuiSize.getSceneSize(ProgConfig.SYSTEM_SIZE_GUI, false));
            this.primaryStage.setScene(scene);
            if (P2InfoFactory.getOs() == P2InfoFactory.OperatingSystemType.LINUX && ProgData.firstProgramStart) {
                P2Log.sysLog("FirstProgramStart & LINUX: Resizable: false");
                this.primaryStage.setResizable(false);
                scene.setOnMouseEntered(mouseEvent -> Platform.runLater(() -> {
                    if (!this.done) {
                        this.done = true;
                        P2GuiSize.setSizePos(ProgConfig.SYSTEM_SIZE_GUI, this.primaryStage, null);
                        this.primaryStage.setResizable(true);
                        P2Log.sysLog("FirstProgramStart & LINUX: Resizable: true");
                    }
                }));
            }
            if (!ProgData.startMinimized && (ProgConfig.SYSTEM_GUI_LAST_START_WAS_MAXIMISED.get() || ProgConfig.SYSTEM_GUI_START_ALWAYS_MAXIMISED.get())) {
                P2GuiSize.setPos(ProgConfig.SYSTEM_SIZE_GUI, this.primaryStage);
                this.primaryStage.setMaximized(true);
                if (P2InfoFactory.getOs() == P2InfoFactory.OperatingSystemType.LINUX) {
                    this.primaryStage.setOnShown(e -> this.startMaximised());
                }
            } else {
                this.primaryStage.setOnShowing(e -> P2GuiSize.setSizePos(ProgConfig.SYSTEM_SIZE_GUI, this.primaryStage, null));
                this.primaryStage.setOnShown(e -> P2GuiSize.setSizePos(ProgConfig.SYSTEM_SIZE_GUI, this.primaryStage, null));
            }
            this.primaryStage.setOnCloseRequest(e -> {
                e.consume();
                ProgQuit.quit(false);
            });
            ProgConfig.SYSTEM_DARK_THEME.addListener((u, o, n) -> ProgColorList.setColorTheme());
            PShortKeyFactory.addShortKey(scene);
            P2LibInit.addP2CssToScene(scene);
            if (ProgData.startMinimized) {
                this.primaryStage.setIconified(true);
                P2DialogExtra.getDialogList().forEach(d -> d.getStage().setIconified(true));
            }
            this.primaryStage.iconifiedProperty().addListener((u, o, n) -> P2DialogExtra.getDialogList().forEach(d -> d.getStage().setIconified((boolean)n)));
            this.primaryStage.show();
            if (ProgData.firstProgramStart) {
                ProgConfig.SYSTEM_DARK_THEME.set(ProgConfig.SYSTEM_DARK_THEME_START.get());
                ProgConfig.SYSTEM_BLACK_WHITE_ICON.set(ProgConfig.SYSTEM_BLACK_WHITE_ICON_START.get());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void startMaximised() {
        new Thread(new Task<Void>(){

            @Override
            protected Void call() {
                try {
                    this.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    if (ProgData.getInstance().primaryStage.isShowing()) {
                        P2GuiSize.getSize(ProgConfig.SYSTEM_SIZE_GUI, ProgData.getInstance().primaryStage);
                        P2GuiSize.setSizePos(ProgConfig.SYSTEM_SIZE_GUI, MTPlayer.this.primaryStage, null);
                    }
                });
                return null;
            }
        }).start();
    }
}

