#!/bin/sh
#
# Wenn der Arbeitsspeicher knapp ist, kann das helfen:
# java -Xms128M -Xmx1G -jar ./MTPlayer.jar "$@"


dir=$(dirname "$(readlink -f "$0")")
cd "$dir"

einstellungen="Einstellungen"

if [ -f ../../MTPlayer.jar ]; then
	cd ..
	cd ..
fi


if [ -d "Java" ]; then
  echo "dann Java aus dem Progverzeichis: Java"
  ./Java/bin/java -jar ./MTPlayer.jar $einstellungen "$@"

elif [ -d "java" ]; then
  echo "dann Java aus dem Progverzeichis: java"
  ./java/bin/java -jar ./MTPlayer.jar $einstellungen "$@"

else
  echo "dann Java vom System"
  
  if [ -n "$JAVA_HOME" ]; then
    $JAVA_HOME/bin/java -jar ./MTPlayer.jar $einstellungen "$@"
  else
    java -jar ./MTPlayer.jar $einstellungen "$@"
  fi
fi

