/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.file;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class P2FileSize
implements Comparable<P2FileSize> {
    private static final long GBYTE = 1000000000L;
    private static final long MBYTE = 1000000L;
    private static final long KBYTE = 1000L;
    private static final NumberFormat formatter = new DecimalFormat("#0.00");
    private long sizeL = 0L;
    private String sizeStr = "";

    public P2FileSize(long sizeL) {
        this.sizeL = sizeL;
        this.convertToStr();
    }

    public P2FileSize(String sizeStr) {
        try {
            this.sizeL = Long.parseLong(sizeStr);
        }
        catch (Exception ex) {
            this.sizeL = 0L;
        }
        this.convertToStr();
    }

    public static String convertToStr(long sizeL) {
        if (sizeL <= 0L) {
            return "";
        }
        if (sizeL < 1000L) {
            return sizeL + " B";
        }
        if (sizeL < 1000000L) {
            double size = 1.0 * (double)sizeL / 1000.0;
            return formatter.format(size) + " kB";
        }
        if (sizeL < 1000000000L) {
            double size = 1.0 * (double)sizeL / 1000000.0;
            return formatter.format(size) + " MB";
        }
        double size = 1.0 * (double)sizeL / 1.0E9;
        return formatter.format(size) + " GB";
    }

    public static long convertToLong(String size) {
        if (size.isEmpty()) {
            return 0L;
        }
        size = size.replace(",", ".");
        try {
            if (size.endsWith(" B")) {
                size = size.replace(" B", "");
                return Double.valueOf(size).longValue();
            }
            if (size.endsWith(" kB")) {
                size = size.replace(" kB", "");
                return Double.valueOf(Double.valueOf(size) * 1000.0).longValue();
            }
            if (size.endsWith(" MB")) {
                size = size.replace(" MB", "");
                return Double.valueOf(Double.valueOf(size) * 1000000.0).longValue();
            }
            if (size.endsWith(" GB")) {
                size = size.replace(" GB", "");
                return Double.valueOf(Double.valueOf(size) * 1.0E9).longValue();
            }
            return Double.valueOf(size).longValue();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private void convertToStr() {
        this.sizeStr = P2FileSize.convertToStr(this.sizeL);
    }

    private void convertToLong() {
        this.sizeL = P2FileSize.convertToLong(this.sizeStr);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof P2FileSize)) {
            return false;
        }
        P2FileSize other = (P2FileSize)obj;
        return other.sizeL == this.sizeL;
    }

    public long getSizeL() {
        return this.sizeL;
    }

    public void setSizeL(long sizeL) {
        this.sizeL = sizeL;
        this.convertToStr();
    }

    public void addSizeL(long sizeL) {
        this.sizeL += sizeL;
        this.convertToStr();
    }

    public String getSizeStr() {
        return this.sizeStr;
    }

    public void setSizeStr(String sizeStr) {
        this.sizeStr = sizeStr;
        this.convertToLong();
    }

    public String toString() {
        return this.sizeStr;
    }

    @Override
    public int compareTo(P2FileSize o) {
        if (this.sizeL < o.sizeL) {
            return -1;
        }
        if (this.sizeL == o.sizeL) {
            return 0;
        }
        return 1;
    }
}

