/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.duration;

import de.p2tools.p2lib.tools.P2StringUtils;
import de.p2tools.p2lib.tools.duration.P2Counter;
import de.p2tools.p2lib.tools.log.P2Log;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class P2Duration {
    private static Instant onlyPingTime = Instant.now();
    private static final DecimalFormat DF = new DecimalFormat("###,##0.00");
    private static int sum = 0;
    private static final Map<String, P2Counter> counterMap = new HashMap<String, P2Counter>(25);
    private static final String DURATION = "DURATION";
    private static final String PING = "PING";

    public static synchronized void counterStart(String counterName) {
        P2Counter p2Counter = P2Duration.getCounterEntry(P2Duration.getName(counterName));
        p2Counter.startCounter();
    }

    public static synchronized List<String> counterStop(String counterName) {
        P2Counter p2Counter = P2Duration.getCounterEntry(P2Duration.getName(counterName));
        ++p2Counter.count;
        Duration duration = Duration.between(p2Counter.startTime, Instant.now());
        p2Counter.duration = p2Counter.duration.plus(duration);
        ArrayList<String> txt = new ArrayList<String>();
        txt.add("       Anzahl:   " + p2Counter.count);
        txt.add("        Dauer:   " + P2Duration.roundDuration(duration));
        txt.add("            \u00d8:   " + P2Duration.roundDuration(p2Counter.getAverage()));
        txt.add("  Gesamtdauer:   " + P2Duration.roundDuration(p2Counter.duration));
        P2Duration.onlyPing(P2Duration.getClassName(), DURATION, counterName, txt, p2Counter.pingTextList);
        return txt;
    }

    private static P2Counter getCounterEntry(String counterName) {
        P2Counter p2Counter = counterMap.get(counterName);
        if (p2Counter == null) {
            p2Counter = new P2Counter(counterName);
            counterMap.put(counterName, p2Counter);
        }
        return p2Counter;
    }

    private static String getName(String counterName) {
        return P2Duration.getCallerClass() + "." + counterName;
    }

    private static String getCallerClass() {
        String s = "";
        try {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            String rawFQN = stElements[4].toString().split("\\(")[0];
            s = Class.forName(rawFQN.substring(0, rawFQN.lastIndexOf(46))).getSimpleName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return s;
    }

    public static synchronized void onlyPing(String text) {
        P2Duration.onlyPing(P2Duration.getClassName(), PING, text, null, null);
    }

    private static void onlyPing(String className, String kind, String text, List<String> extraText, List<String> pingText) {
        Instant now = Instant.now();
        ArrayList<String> list = new ArrayList<String>();
        list.add("------------------------------------------------------------");
        list.add(kind + " " + sum++ + ":  " + text + "  [" + P2Duration.roundDuration(Duration.between(onlyPingTime, now)) + "]");
        list.add("Klasse:  " + className);
        if (pingText != null && !pingText.isEmpty()) {
            pingText.stream().forEach(s -> list.add((String)s));
        }
        if (extraText != null && !extraText.isEmpty()) {
            extraText.stream().forEach(txt -> list.add("  " + txt));
        }
        list.add("------------------------------------------------------------");
        P2StringUtils.appendString(list, "|  ", "-");
        P2Log.durationLog(list);
        onlyPingTime = now;
    }

    public static synchronized ArrayList<String> getCounter() {
        ArrayList<String> stringList = new ArrayList<String>();
        if (counterMap.isEmpty()) {
            stringList.add("keine Counter");
            return stringList;
        }
        int max = 0;
        stringList.add("Counter:");
        stringList.add("============");
        ArrayList<P2Counter> P2CounterList = new ArrayList<P2Counter>(counterMap.values());
        for (P2Counter P2Counter2 : P2CounterList) {
            if (P2Counter2.counterName.length() <= max) continue;
            max = P2Counter2.counterName.length();
        }
        ++max;
        for (P2Counter P2Counter2 : P2CounterList) {
            while (P2Counter2.counterName.length() < max) {
                P2Counter2.counterName = P2Counter2.counterName + " ";
            }
        }
        Collections.sort(P2CounterList);
        for (P2Counter p2Counter : P2CounterList) {
            stringList.add(p2Counter.counterName + " Anzahl: " + P2StringUtils.increaseString(2, true, "" + p2Counter.count) + "   \u2211: " + P2StringUtils.increaseString(10, true, P2Duration.roundDuration(p2Counter.duration)) + "   \u00d8: " + P2StringUtils.increaseString(10, true, P2Duration.roundDuration(p2Counter.getAverage())));
        }
        return stringList;
    }

    private static String getClassName() {
        Object kl;
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[2];
        String className = methodCaller.getClassName() + "." + methodCaller.getMethodName();
        try {
            kl = className;
            while (((String)kl).contains(".") && !Character.isUpperCase(((String)kl).charAt(0))) {
                kl = ((String)kl).substring(((String)kl).indexOf(".") + 1);
            }
        }
        catch (Exception ignored) {
            kl = className;
        }
        return kl;
    }

    private static String roundDuration(Duration duration) {
        return P2Duration.roundDuration(duration.toMillis());
    }

    private static String roundDuration(long millis) {
        String ret = (double)millis > 1000.0 ? DF.format((double)millis / 1000.0) + " s" : DF.format(millis) + " ms";
        return ret;
    }
}

