/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.date;

import de.p2tools.p2lib.tools.date.P2DateConst;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class P2LDateTimeFactory {
    private P2LDateTimeFactory() {
    }

    public static LocalDateTime setDate(String strDate, String strTime) {
        if (strDate.isEmpty()) {
            LocalDateTime localDateTime = LocalDateTime.now();
            return localDateTime;
        }
        try {
            LocalDateTime localDateTime;
            if (strTime.isEmpty()) {
                LocalDate ld = LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_dd_MM_yyyy);
                localDateTime = ld.atStartOfDay();
            } else {
                localDateTime = LocalDateTime.parse(strDate + " " + strTime, P2DateConst.DT_FORMATTER_dd_MM_yyyy___HH__mm__ss);
            }
            return localDateTime;
        }
        catch (Exception exception) {
            LocalDateTime localDateTime = LocalDateTime.MIN;
            return localDateTime;
        }
    }

    public static LocalDateTime setDate(String strDateTime) {
        if (strDateTime.isEmpty()) {
            LocalDateTime localDateTime = LocalDateTime.now();
            return localDateTime;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(strDateTime, P2DateConst.DT_FORMATTER_dd_MM_yyyy___HH__mm__ss);
            return localDateTime;
        }
        catch (Exception exception) {
            LocalDateTime localDateTime = LocalDateTime.MIN;
            return localDateTime;
        }
    }

    public static String toStringDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        if (localDateTime.isEqual(LocalDateTime.MIN)) {
            return "";
        }
        return localDateTime.format(P2DateConst.DT_FORMATTER_dd_MM_yyyy);
    }

    public static String toStringTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        if (localDateTime.isEqual(LocalDateTime.MIN)) {
            return "";
        }
        return localDateTime.format(P2DateConst.DT_FORMATTER_HH__mm);
    }

    public static LocalDateTime fromString(String strDate) {
        return P2LDateTimeFactory.fromString(strDate, P2DateConst.DT_FORMATTER_dd_MM_yyyy___HH__mm__ss);
    }

    public static LocalDateTime fromString(String strDate, DateTimeFormatter dateFactory) {
        try {
            if (strDate.isEmpty()) {
                return LocalDateTime.MIN;
            }
            return LocalDateTime.parse(strDate, dateFactory);
        }
        catch (Exception ex) {
            return LocalDateTime.MIN;
        }
    }

    public static LocalDateTime fromStringR(String strDate) {
        try {
            if (strDate.isEmpty()) {
                return LocalDateTime.MIN;
            }
            return LocalDateTime.parse(strDate, P2DateConst.DT_FORMATTER_yyyy_MM_dd___HH__mm__ss);
        }
        catch (Exception ex) {
            return LocalDateTime.MIN;
        }
    }

    public static String toString(LocalDateTime localDateTime, DateTimeFormatter dateFactory) {
        if (localDateTime == null) {
            return "";
        }
        if (localDateTime.isEqual(LocalDateTime.MIN)) {
            return "";
        }
        return localDateTime.format(dateFactory);
    }

    public static String toString(LocalDateTime localDateTime) {
        return P2LDateTimeFactory.toString(localDateTime, P2DateConst.DT_FORMATTER_dd_MM_yyyy___HH__mm__ss);
    }

    public static String toStringR(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        if (localDateTime.isEqual(LocalDateTime.MIN)) {
            return "";
        }
        return localDateTime.format(P2DateConst.DT_FORMATTER_yyyy_MM_dd___HH__mm__ss);
    }
}

